/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;

public final class JavassistProxyFactoryFactory {
    private static final ProxyFactory proxyFactory;
    private ClassPool classPool = new ClassPool();

    private JavassistProxyFactoryFactory() {
        this.classPool.importPackage("java.sql");
        this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        try {
            String string = "{ _checkClosed(); try { return ((cast) delegate).method($$); } catch (SQLException e) { _checkException(e); throw e;} }";
            this.generateProxyClass(Connection.class, ConnectionProxy.class, string);
            string = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { _checkException(e); throw e;} }";
            this.generateProxyClass(Statement.class, StatementProxy.class, string);
            this.generateProxyClass(CallableStatement.class, CallableStatementProxy.class, string);
            this.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class, string);
            this.generateProxyClass(ResultSet.class, ResultSetProxy.class, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ProxyFactory getProxyFactory() {
        return proxyFactory;
    }

    private ProxyFactory generateProxyFactory() throws Exception {
        String string = ProxyFactory.class.getPackage().getName();
        CtClass ctClass = this.classPool.makeClass(string + ".JavassistProxyFactory");
        CtClass ctClass2 = this.classPool.getCtClass(ProxyFactory.class.getName());
        ctClass.setSuperclass(ctClass2);
        ctClass.setModifiers(16);
        for (CtMethod ctMethod : ctClass2.getDeclaredMethods()) {
            CtMethod ctMethod2 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass, null);
            StringBuilder stringBuilder = new StringBuilder("{");
            if ("getProxyConnection".equals(ctMethod2.getName())) {
                stringBuilder.append("return new ").append(string).append(".ConnectionJavassistProxy($$);");
            }
            if ("getProxyStatement".equals(ctMethod2.getName())) {
                stringBuilder.append("return new ").append(string).append(".StatementJavassistProxy($$);");
            }
            if ("getProxyPreparedStatement".equals(ctMethod2.getName())) {
                stringBuilder.append("return new ").append(string).append(".PreparedStatementJavassistProxy($$);");
            }
            if ("getProxyResultSet".equals(ctMethod2.getName())) {
                stringBuilder.append("return $2 != null ? new ").append(string).append(".ResultSetJavassistProxy($$) : null;");
            }
            if ("getProxyCallableStatement".equals(ctMethod2.getName())) {
                stringBuilder.append("return new ").append(string).append(".CallableStatementJavassistProxy($$);");
            }
            stringBuilder.append('}');
            ctMethod2.setBody(stringBuilder.toString());
            ctClass.addMethod(ctMethod2);
        }
        Class clazz = ctClass.toClass(this.classPool.getClassLoader(), null);
        return (ProxyFactory)clazz.newInstance();
    }

    private <T> Class<T> generateProxyClass(Class<T> clazz, Class<?> clazz2, String string) throws Exception {
        String string2 = clazz2.getName();
        CtClass ctClass = this.classPool.getCtClass(string2);
        CtClass ctClass2 = this.classPool.makeClass(string2.replace("Proxy", "JavassistProxy"), ctClass);
        ctClass2.setModifiers(16);
        HashSet<String> hashSet = new HashSet<String>();
        for (CtMethod object : ctClass.getMethods()) {
            if ((object.getModifiers() & 0x400) == 1024) continue;
            hashSet.add(object.getName() + object.getSignature());
        }
        string = string.replace("cast", clazz.getName());
        HashSet hashSet2 = new HashSet();
        Set<Class<?>> set = ClassLoaderUtils.getAllInterfaces(clazz);
        for (Class<?> clazz3 : set) {
            CtClass ctClass3 = this.classPool.getCtClass(clazz3.getName());
            ctClass2.addInterface(ctClass3);
            for (CtMethod ctMethod : ctClass3.getDeclaredMethods()) {
                if (hashSet.contains(ctMethod.getName() + ctMethod.getSignature()) || hashSet2.contains(ctMethod.getName() + ctMethod.getSignature())) continue;
                CtMethod ctMethod2 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass2, null);
                hashSet2.add(ctMethod.getName() + ctMethod.getSignature());
                String string3 = string.replace("method", ctMethod2.getName());
                if (ctMethod2.getReturnType() == CtClass.voidType) {
                    string3 = string3.replace("return", "");
                }
                ctMethod2.setBody(string3);
                ctClass2.addMethod(ctMethod2);
            }
        }
        return ctClass2.toClass(this.classPool.getClassLoader(), null);
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavassistProxyFactoryFactory.class.getClassLoader());
            JavassistProxyFactoryFactory javassistProxyFactoryFactory = new JavassistProxyFactoryFactory();
            proxyFactory = javassistProxyFactoryFactory.generateProxyFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

