/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariResultSetProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariClassTransformer
implements ClassFileTransformer {
    private final Logger LOGGER = LoggerFactory.getLogger(HikariClassTransformer.class);
    public static final int UNDEFINED = 0;
    public static final int CONNECTION = 1;
    public static final int STATEMENT = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int RESULTSET = 5;
    public static final int CONNECTION_SUBCLASS = 6;
    public static final int STATEMENT_SUBCLASS = 7;
    public static final int PREPARED_STATEMENT_SUBCLASS = 8;
    public static final int CALLABLE_STATEMENT_SUBCLASS = 9;
    public static final int RESULTSET_SUBCLASS = 10;
    private static ClassPool classPool;
    private volatile boolean agentFailed;
    private volatile HashSet<String> scanClasses;
    private int classType;

    public void setScanClass(HashSet<String> hashSet, int n) {
        this.scanClasses = new HashSet();
        for (String string : hashSet) {
            this.scanClasses.add(string.replace('.', '/'));
        }
        this.classType = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        if (this.classType == 0 || !this.scanClasses.contains(string)) {
            return byArray;
        }
        if (classPool == null) {
            classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classPool.getClassLoader());
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
            this.LOGGER.info("Instrumenting class {}", (Object)string);
            switch (this.classType) {
                case 1: {
                    byte[] byArray2 = this.transformBaseConnection(classFile);
                    return byArray2;
                }
                case 6: {
                    byte[] byArray3 = this.transformConnectionSubclass(classFile);
                    return byArray3;
                }
                case 2: {
                    byte[] byArray4 = this.transformBaseClass(classFile, StatementProxy.class, IHikariStatementProxy.class);
                    return byArray4;
                }
                case 7: {
                    byte[] byArray5 = this.transformClass(classFile, StatementProxy.class);
                    return byArray5;
                }
                case 3: {
                    byte[] byArray6 = this.transformBaseClass(classFile, PreparedStatementProxy.class, IHikariStatementProxy.class);
                    return byArray6;
                }
                case 8: {
                    byte[] byArray7 = this.transformClass(classFile, PreparedStatementProxy.class);
                    return byArray7;
                }
                case 4: {
                    byte[] byArray8 = this.transformBaseClass(classFile, CallableStatementProxy.class, IHikariStatementProxy.class);
                    return byArray8;
                }
                case 9: {
                    byte[] byArray9 = this.transformClass(classFile, CallableStatementProxy.class);
                    return byArray9;
                }
                case 5: {
                    byte[] byArray10 = this.transformBaseClass(classFile, ResultSetProxy.class, IHikariResultSetProxy.class);
                    return byArray10;
                }
                case 10: {
                    byte[] byArray11 = this.transformClass(classFile, ResultSetProxy.class);
                    return byArray11;
                }
            }
            byte[] byArray12 = byArray;
            return byArray12;
        }
        catch (Exception exception) {
            this.agentFailed = true;
            this.LOGGER.error("Error transforming class {}", (Object)string, (Object)exception);
            byte[] byArray13 = byArray;
            return byArray13;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
            this.LOGGER.debug("--------------------------------------------------------------------------");
        }
    }

    public boolean isAgentFailed() {
        return this.agentFailed;
    }

    private byte[] transformBaseConnection(ClassFile classFile) throws Exception {
        String string = classFile.getName();
        CtClass ctClass = classPool.getCtClass(string);
        CtClass ctClass2 = classPool.get(IHikariConnectionProxy.class.getName());
        ctClass.addInterface(ctClass2);
        this.LOGGER.debug("Added interface {} to {}", (Object)ctClass2.getName(), (Object)string);
        CtClass ctClass3 = classPool.get(ConnectionProxy.class.getName());
        this.copyFields(ctClass3, ctClass);
        this.copyMethods(ctClass3, ctClass, classFile);
        this.mergeClassInitializers(ctClass3, ctClass, classFile);
        return this.transformConnectionSubclass(classFile);
    }

    private byte[] transformConnectionSubclass(ClassFile classFile) throws Exception {
        String string = classFile.getName();
        CtClass ctClass = classPool.getCtClass(string);
        CtClass ctClass2 = classPool.get(ConnectionProxy.class.getName());
        this.overrideMethods(ctClass2, ctClass, classFile);
        this.injectTryCatch(ctClass);
        this.specialConnectionInjectCloseCheck(ctClass);
        for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
            ctConstructor.insertBeforeBody("__init();");
        }
        if (this.LOGGER.isDebugEnabled()) {
            ctClass.debugWriteFile(System.getProperty("java.io.tmpdir"));
        }
        return ctClass.toBytecode();
    }

    private byte[] transformBaseClass(ClassFile classFile, Class<?> clazz, Class<?> clazz2) throws Exception {
        String string = classFile.getName();
        CtClass ctClass = classPool.getCtClass(string);
        CtClass ctClass2 = classPool.get(clazz2.getName());
        ctClass.addInterface(ctClass2);
        this.LOGGER.debug("Added interface {} to {}", (Object)ctClass2.getName(), (Object)string);
        CtClass ctClass3 = classPool.get(clazz.getName());
        this.copyFields(ctClass3, ctClass);
        this.copyMethods(ctClass3, ctClass, classFile);
        this.mergeClassInitializers(ctClass3, ctClass, classFile);
        return this.transformClass(classFile, clazz);
    }

    private byte[] transformClass(ClassFile classFile, Class<?> clazz) throws Exception {
        String string = classFile.getName();
        CtClass ctClass = classPool.getCtClass(string);
        CtClass ctClass2 = classPool.get(clazz.getName());
        this.overrideMethods(ctClass2, ctClass, classFile);
        this.injectTryCatch(ctClass);
        if (this.LOGGER.isDebugEnabled()) {
            ctClass.debugWriteFile(System.getProperty("java.io.tmpdir"));
        }
        return ctClass.toBytecode();
    }

    private void copyFields(CtClass ctClass, CtClass ctClass2) throws Exception {
        HashSet<CtField> hashSet = new HashSet<CtField>();
        hashSet.addAll(Arrays.asList(ctClass.getDeclaredFields()));
        hashSet.addAll(Arrays.asList(ctClass.getFields()));
        for (CtField ctField : hashSet) {
            if (ctField.getAnnotation(HikariInject.class) == null) continue;
            CtField ctField2 = new CtField(ctField.getType(), ctField.getName(), ctClass2);
            ctField2.setModifiers(ctField.getModifiers());
            ctClass2.addField(ctField2);
            this.LOGGER.debug("Copied field {}.{} to {}", new Object[]{ctField.getDeclaringClass().getSimpleName(), ctField.getName(), ctClass2.getSimpleName()});
        }
    }

    private void copyMethods(CtClass ctClass, CtClass ctClass2, ClassFile classFile) throws Exception {
        ConstPool constPool = classFile.getConstPool();
        for (CtMethod ctMethod : ctClass.getMethods()) {
            if (ctMethod.getAnnotation(HikariInject.class) == null) continue;
            CtMethod ctMethod2 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass2, null);
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(HikariInject.class.getName(), constPool);
            annotationsAttribute.setAnnotation(annotation);
            ctMethod2.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
            ctClass2.addMethod(ctMethod2);
            this.LOGGER.debug("Copied method {}.{} to {}", new Object[]{ctMethod.getDeclaringClass().getSimpleName(), ctMethod.getName(), ctClass2.getSimpleName()});
        }
    }

    private void overrideMethods(CtClass ctClass, CtClass ctClass2, ClassFile classFile) throws Exception {
        ConstPool constPool = classFile.getConstPool();
        AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(HikariOverride.class.getName(), constPool);
        annotationsAttribute.setAnnotation(annotation);
        for (CtMethod ctMethod : ctClass.getMethods()) {
            if (ctMethod.getAnnotation(HikariOverride.class) == null || (ctClass2.getModifiers() & 0x400) == 1024) continue;
            try {
                CtMethod ctMethod2 = ctClass2.getDeclaredMethod(ctMethod.getName(), ctMethod.getParameterTypes());
                this.LOGGER.debug("Rename method {}{} to __{}", new Object[]{ctMethod2.getName(), ctMethod2.getSignature(), ctMethod2.getName()});
                ctMethod2.setName("__" + ctMethod2.getName());
                ctMethod2.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
                CtMethod ctMethod3 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass2, null);
                ctMethod3.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
                ctClass2.addMethod(ctMethod3);
                this.LOGGER.debug("Override method {}.{} in {}", new Object[]{ctMethod.getDeclaringClass().getSimpleName(), ctMethod.getName(), ctClass2.getSimpleName()});
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private void mergeClassInitializers(CtClass ctClass, CtClass ctClass2, ClassFile classFile) throws Exception {
        CtConstructor ctConstructor = ctClass.getClassInitializer();
        if (ctConstructor == null) {
            return;
        }
        CtConstructor ctConstructor2 = ctClass2.getClassInitializer();
        if (ctConstructor2 == null) {
            if (ctConstructor != null) {
                CtConstructor ctConstructor3 = CtNewConstructor.copy((CtConstructor)ctConstructor, (CtClass)ctClass2, null);
                ctClass2.addConstructor(ctConstructor3);
                CtMethod ctMethod = CtNewMethod.make((int)8, (CtClass)CtClass.voidType, (String)"__static", null, null, (String)"{}", (CtClass)ctClass2);
                ctClass2.addMethod(ctMethod);
                this.LOGGER.debug("Copied static initializer of {} to {}", (Object)ctClass.getSimpleName(), (Object)ctClass2.getSimpleName());
            }
        } else {
            CtMethod ctMethod = ctConstructor2.toMethod("__static", ctClass2);
            ctClass2.addMethod(ctMethod);
            ctClass2.removeConstructor(ctConstructor2);
            this.LOGGER.debug("Move static initializer of {}", (Object)ctClass2.getSimpleName());
            CtConstructor ctConstructor4 = CtNewConstructor.copy((CtConstructor)ctConstructor, (CtClass)ctClass2, null);
            ctClass2.addConstructor(ctConstructor4);
            this.LOGGER.debug("Copied static initializer of {} to {}", (Object)ctClass.getSimpleName(), (Object)ctClass2.getSimpleName());
        }
    }

    private void injectTryCatch(CtClass ctClass) throws Exception {
        block0: for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            if ((ctMethod.getModifiers() & 1) != 1 || (ctMethod.getModifiers() & 8) == 8 || ctMethod.getAnnotation(HikariInject.class) != null || ctMethod.getAnnotation(HikariOverride.class) != null || ctMethod.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass ctClass2 : ctMethod.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(ctClass2.getName())) continue;
                this.LOGGER.debug("Injecting try..catch into {}{}", (Object)ctMethod.getName(), (Object)ctMethod.getSignature());
                ctMethod.addCatch("_checkException($e); throw $e;", ctClass2);
                continue block0;
            }
        }
    }

    private void specialConnectionInjectCloseCheck(CtClass ctClass) throws Exception {
        block0: for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            if ((ctMethod.getModifiers() & 1) != 1 || (ctMethod.getModifiers() & 8) == 8 || ctMethod.getAnnotation(HikariInject.class) != null || ctMethod.getAnnotation(HikariOverride.class) != null || ctMethod.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass ctClass2 : ctMethod.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(ctClass2.getName())) continue;
                this.LOGGER.debug("Injecting _checkClosed() call into {}{}", (Object)ctMethod.getName(), (Object)ctMethod.getSignature());
                ctMethod.insertBefore("_checkClosed();");
                continue block0;
            }
        }
    }
}

