/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static ProxyFactory PROXY_FACTORY;
    @HikariInject
    protected static final Set<String> SQL_ERRORS;
    @HikariInject
    protected ThreadLocal<Boolean> _isClosed;
    @HikariInject
    protected ArrayList<IHikariStatementProxy> _openStatements;
    @HikariInject
    protected HikariPool _parentPool;
    @HikariInject
    protected boolean _forceClose;
    @HikariInject
    protected long _creationTime;
    @HikariInject
    protected long _lastAccess;
    @HikariInject
    protected StackTraceElement[] _stackTrace;
    @HikariInject
    protected TimerTask _leakTask;
    protected final Connection delegate;

    protected ConnectionProxy(Connection connection) {
        this.delegate = connection;
        this.__init();
    }

    @Override
    @HikariInject
    public void _unregisterStatement(Object object) {
        if (!this._isClosed.get().booleanValue()) {
            this._openStatements.remove(object);
        }
    }

    @Override
    @HikariInject
    public final long _getCreationTime() {
        return this._creationTime;
    }

    @Override
    @HikariInject
    public final long _getLastAccess() {
        return this._lastAccess;
    }

    @Override
    @HikariInject
    public final void _markLastAccess() {
        this._lastAccess = System.currentTimeMillis();
    }

    @Override
    @HikariInject
    public final void _setParentPool(HikariPool hikariPool) {
        this._parentPool = hikariPool;
    }

    @Override
    @HikariInject
    public final void _unclose() {
        this._isClosed.set(false);
    }

    @Override
    @HikariInject
    public final void _captureStack(long l, Timer timer) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        this._stackTrace = new StackTraceElement[stackTraceElementArray.length - 4];
        System.arraycopy(stackTraceElementArray, 4, this._stackTrace, 0, this._stackTrace.length);
        this._leakTask = new LeakTask(this._stackTrace, l);
        timer.schedule(this._leakTask, l);
    }

    @Override
    @HikariInject
    public final boolean _isBrokenConnection() {
        return this._forceClose;
    }

    @Override
    @HikariInject
    public final void _checkException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        if (string != null) {
            this._forceClose |= string.startsWith("08") | SQL_ERRORS.contains(string);
        }
    }

    @HikariInject
    protected void __init() {
        if (this._openStatements == null) {
            this._openStatements = new ArrayList(64);
            this._creationTime = this._lastAccess = System.currentTimeMillis();
            this._isClosed = new ThreadLocal();
            this._isClosed.set(false);
        }
    }

    @HikariInject
    protected final void _checkClosed() throws SQLException {
        if (this._isClosed.get().booleanValue()) {
            throw new SQLException("Connection is closed");
        }
    }

    @HikariInject
    protected final <T extends IHikariStatementProxy> T _trackStatement(T t) {
        if (t._getConnectionProxy() == null) {
            t._setConnectionProxy(this);
            this._openStatements.add(t);
        }
        return t;
    }

    @Override
    @HikariOverride
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this._leakTask != null) {
                this._leakTask.cancel();
                this._leakTask = null;
            }
            try {
                int n = this._openStatements.size();
                for (int i = 0; i < n; ++i) {
                    this._openStatements.get(i).close();
                }
                if (!this.getAutoCommit()) {
                    this.rollback();
                }
            }
            catch (SQLException sQLException) {
                this._checkException(sQLException);
                throw sQLException;
            }
            finally {
                this._isClosed.set(true);
                this._openStatements.clear();
                this._parentPool.releaseConnection(this);
            }
        }
    }

    @Override
    @HikariOverride
    public boolean isClosed() throws SQLException {
        return this._isClosed.get();
    }

    @Override
    @HikariOverride
    public Statement createStatement() throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)this.__createStatement();
            return this._trackStatement(iHikariStatementProxy);
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public Statement createStatement(int n, int n2) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)this.__createStatement(n, n2);
            return this._trackStatement(iHikariStatementProxy);
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)this.__createStatement(n, n2, n3);
            return this._trackStatement(iHikariStatementProxy);
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String string) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareCall(string));
            return (CallableStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareCall(string, n, n2));
            return (CallableStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareCall(string, n, n2, n3));
            return (CallableStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string, n));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string, n, n2));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string, n, n2, n3));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string, nArray));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this._checkClosed();
        try {
            IHikariStatementProxy iHikariStatementProxy = (IHikariStatementProxy)((Object)this.__prepareStatement(string, stringArray));
            return (PreparedStatement)((Object)this._trackStatement(iHikariStatementProxy));
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public boolean isValid(int n) throws SQLException {
        if (this._isClosed.get().booleanValue()) {
            return false;
        }
        try {
            return this.__isValid(n);
        }
        catch (SQLException sQLException) {
            this._checkException(sQLException);
            throw sQLException;
        }
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    @Override
    public final void __close() throws SQLException {
        this.delegate.close();
    }

    public final boolean __isValid(int n) throws SQLException {
        return this.delegate.isValid(n);
    }

    public final Statement __createStatement() throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement());
    }

    public final Statement __createStatement(int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(n, n2));
    }

    public final Statement __createStatement(int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(n, n2, n3));
    }

    public final CallableStatement __prepareCall(String string) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string));
    }

    public final CallableStatement __prepareCall(String string, int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string, n, n2));
    }

    public final CallableStatement __prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string, n, n2, n3));
    }

    public final PreparedStatement __prepareStatement(String string) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string));
    }

    public final PreparedStatement __prepareStatement(String string, int n) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n));
    }

    public final PreparedStatement __prepareStatement(String string, int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n, n2));
    }

    public final PreparedStatement __prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n, n2, n3));
    }

    public final PreparedStatement __prepareStatement(String string, int[] nArray) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, nArray));
    }

    public final PreparedStatement __prepareStatement(String string, String[] stringArray) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, stringArray));
    }

    static {
        SQL_ERRORS = new HashSet<String>();
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("01002");
        ConnectionProxy.__static();
    }
}

