/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariResultSetProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class StatementProxy
implements IHikariStatementProxy,
Statement {
    protected static ProxyFactory PROXY_FACTORY;
    @HikariInject
    protected IHikariConnectionProxy _connection;
    @HikariInject
    protected boolean _isClosed;
    protected final Statement delegate;

    protected StatementProxy(IHikariConnectionProxy iHikariConnectionProxy, Statement statement) {
        this._connection = iHikariConnectionProxy;
        this.delegate = statement;
    }

    @Override
    @HikariInject
    public void _setConnectionProxy(IHikariConnectionProxy iHikariConnectionProxy) {
        this._connection = iHikariConnectionProxy;
    }

    @Override
    @HikariInject
    public IHikariConnectionProxy _getConnectionProxy() {
        return this._connection;
    }

    @Override
    @HikariInject
    public final void _checkException(SQLException sQLException) {
        this._connection._checkException(sQLException);
    }

    @Override
    @HikariInject
    public void _releaseResultSet(IHikariResultSetProxy iHikariResultSetProxy) {
    }

    @HikariInject
    protected <T extends ResultSet> T _trackResultSet(T t) {
        if (t != null) {
            ((IHikariResultSetProxy)((Object)t))._setProxyStatement(this);
        }
        return t;
    }

    @Override
    @HikariOverride
    public void close() throws SQLException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        this._connection._unregisterStatement(this);
        try {
            this.__close();
        }
        catch (SQLException sQLException) {
            this._connection._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this._trackResultSet(this.__executeQuery(string));
        }
        catch (SQLException sQLException) {
            this._connection._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public ResultSet getResultSet() throws SQLException {
        try {
            return this._trackResultSet(this.__getResultSet());
        }
        catch (SQLException sQLException) {
            this._connection._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    @HikariOverride
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this._trackResultSet(this.__getGeneratedKeys());
        }
        catch (SQLException sQLException) {
            this._connection._checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    public void __close() throws SQLException {
        if (this.delegate.isClosed()) {
            return;
        }
        this.delegate.close();
    }

    public ResultSet __executeQuery(String string) throws SQLException {
        return this.wrapResultSet(this.delegate.executeQuery(string));
    }

    public ResultSet __getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.delegate.getGeneratedKeys());
    }

    public ResultSet __getResultSet() throws SQLException {
        return this.wrapResultSet(this.delegate.getResultSet());
    }

    protected ResultSet wrapResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = PROXY_FACTORY.getProxyResultSet(this, resultSet);
        }
        return resultSet;
    }

    static {
        StatementProxy.__static();
    }
}

