/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final ProxyFactory PROXY_FACTORY;
    private static final Set<String> SQL_ERRORS;
    protected final Connection delegate;
    private final ArrayList<Statement> openStatements;
    private final HikariPool parentPool;
    private boolean isClosed;
    private boolean forceClose;
    private final long creationTime;
    private volatile long lastAccess;
    private StackTraceElement[] leakTrace;
    private TimerTask leakTask;

    protected ConnectionProxy(HikariPool hikariPool, Connection connection) {
        this.parentPool = hikariPool;
        this.delegate = connection;
        this.creationTime = this.lastAccess = System.currentTimeMillis();
        this.openStatements = new ArrayList();
    }

    @Override
    public final void unregisterStatement(Object object) {
        if (!this.isClosed) {
            this.openStatements.remove(object);
        }
    }

    @Override
    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public final void unclose() {
        this.isClosed = false;
    }

    @Override
    public final void realClose() throws SQLException {
        this.delegate.close();
    }

    @Override
    public final void captureStack(long l, Timer timer) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        this.leakTrace = new StackTraceElement[stackTraceElementArray.length - 4];
        System.arraycopy(stackTraceElementArray, 4, this.leakTrace, 0, this.leakTrace.length);
        this.leakTask = new LeakTask(this.leakTrace, l);
        timer.schedule(this.leakTask, l);
    }

    @Override
    public final boolean isBrokenConnection() {
        return this.forceClose;
    }

    @Override
    public final void checkException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        if (string != null) {
            this.forceClose |= string.startsWith("08") | SQL_ERRORS.contains(string);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    private final <T extends Statement> T trackStatement(T t) {
        this.openStatements.add(t);
        return t;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            if (this.leakTask != null) {
                this.leakTask.cancel();
                this.leakTask = null;
            }
            try {
                int n = this.openStatements.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        this.openStatements.get(i).close();
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.checkException(sQLException);
                    }
                }
                if (!this.getAutoCommit()) {
                    this.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.checkException(sQLException);
                throw sQLException;
            }
            finally {
                this.isClosed = true;
                this.openStatements.clear();
                this.lastAccess = System.currentTimeMillis();
                this.parentPool.releaseConnection(this);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__createStatement());
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareCall(string));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        try {
            return this.trackStatement(this.__prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(n);
        }
        catch (SQLException sQLException) {
            this.checkException(sQLException);
            throw sQLException;
        }
    }

    private final Statement __createStatement() throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement());
    }

    private final Statement __createStatement(int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(n, n2));
    }

    private final Statement __createStatement(int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(n, n2, n3));
    }

    private final CallableStatement __prepareCall(String string) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string));
    }

    private final CallableStatement __prepareCall(String string, int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string, n, n2));
    }

    private final CallableStatement __prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(string, n, n2, n3));
    }

    private final PreparedStatement __prepareStatement(String string) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string));
    }

    private final PreparedStatement __prepareStatement(String string, int n) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n));
    }

    private final PreparedStatement __prepareStatement(String string, int n, int n2) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n, n2));
    }

    private final PreparedStatement __prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, n, n2, n3));
    }

    private final PreparedStatement __prepareStatement(String string, int[] nArray) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, nArray));
    }

    private final PreparedStatement __prepareStatement(String string, String[] stringArray) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(string, stringArray));
    }

    static {
        SQL_ERRORS = new HashSet<String>();
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("01002");
        PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
    }
}

