/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class StatementProxy
implements Statement {
    protected static final ProxyFactory PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
    protected final IHikariConnectionProxy connection;
    protected final Statement delegate;
    private boolean isClosed;

    protected StatementProxy(IHikariConnectionProxy iHikariConnectionProxy, Statement statement) {
        this.connection = iHikariConnectionProxy;
        this.delegate = statement;
    }

    protected final void checkException(SQLException sQLException) {
        this.connection.checkException(sQLException);
    }

    protected final ResultSet wrapResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = PROXY_FACTORY.getProxyResultSet(this, resultSet);
        }
        return resultSet;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connection.unregisterStatement(this);
        try {
            this.delegate.close();
        }
        catch (SQLException sQLException) {
            this.connection.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.wrapResultSet(this.delegate.executeQuery(string));
        }
        catch (SQLException sQLException) {
            this.connection.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.wrapResultSet(this.delegate.getResultSet());
        }
        catch (SQLException sQLException) {
            this.connection.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.wrapResultSet(this.delegate.getGeneratedKeys());
        }
        catch (SQLException sQLException) {
            this.connection.checkException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }
}

