/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.slf4j.LoggerFactory;

public final class JavassistProxyFactory {
    private ClassPool classPool = new ClassPool();

    public static void initialize() {
    }

    private JavassistProxyFactory() {
        this.classPool.importPackage("java.sql");
        this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        try {
            String string = "{ checkClosed(); try { return delegate.method($$); } catch (SQLException e) { checkException(e); throw e;} }";
            this.generateProxyClass(Connection.class, ConnectionProxy.class, string);
            string = "{ try { return delegate.method($$); } catch (SQLException e) { checkException(e); throw e;} }";
            this.generateProxyClass(Statement.class, StatementProxy.class, string);
            this.generateProxyClass(ResultSet.class, ResultSetProxy.class, string);
            string = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { checkException(e); throw e;} }";
            this.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class, string);
            this.generateProxyClass(CallableStatement.class, CallableStatementProxy.class, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void modifyProxyFactory() throws Exception {
        String string = JavassistProxyFactory.class.getPackage().getName();
        CtClass ctClass = this.classPool.getCtClass("com.zaxxer.hikari.proxy.ProxyFactory");
        for (CtMethod ctMethod : ctClass.getMethods()) {
            StringBuilder stringBuilder = new StringBuilder("{");
            if ("getProxyConnection".equals(ctMethod.getName())) {
                stringBuilder.append("return new ").append(string).append(".ConnectionJavassistProxy($$);");
            } else if ("getProxyStatement".equals(ctMethod.getName())) {
                stringBuilder.append("return new ").append(string).append(".StatementJavassistProxy($$);");
            } else if ("getProxyPreparedStatement".equals(ctMethod.getName())) {
                stringBuilder.append("return new ").append(string).append(".PreparedStatementJavassistProxy($$);");
            } else if ("getProxyResultSet".equals(ctMethod.getName())) {
                stringBuilder.append("return $2 != null ? new ").append(string).append(".ResultSetJavassistProxy($$) : null;");
            } else {
                if (!"getProxyCallableStatement".equals(ctMethod.getName())) continue;
                stringBuilder.append("return new ").append(string).append(".CallableStatementJavassistProxy($$);");
            }
            stringBuilder.append('}');
            ctMethod.setBody(stringBuilder.toString());
        }
        ctClass.toClass(this.classPool.getClassLoader(), null);
    }

    private <T> Class<T> generateProxyClass(Class<T> clazz, Class<?> clazz2, String string) throws Exception {
        String string2 = clazz2.getName();
        CtClass ctClass = this.classPool.getCtClass(string2);
        CtClass ctClass2 = this.classPool.makeClass(string2.replace("Proxy", "JavassistProxy"), ctClass);
        ctClass2.setModifiers(16);
        HashSet<String> hashSet = new HashSet<String>();
        for (CtMethod object : ctClass.getMethods()) {
            if ((object.getModifiers() & 0x400) == 1024) continue;
            hashSet.add(object.getName() + object.getSignature());
        }
        string = string.replace("cast", clazz.getName());
        HashSet hashSet2 = new HashSet();
        Set<Class<?>> set = ClassLoaderUtils.getAllInterfaces(clazz);
        for (Class<?> clazz3 : set) {
            CtClass ctClass3 = this.classPool.getCtClass(clazz3.getName());
            ctClass2.addInterface(ctClass3);
            for (CtMethod ctMethod : ctClass3.getDeclaredMethods()) {
                if (hashSet.contains(ctMethod.getName() + ctMethod.getSignature()) || hashSet2.contains(ctMethod.getName() + ctMethod.getSignature())) continue;
                hashSet2.add(ctMethod.getName() + ctMethod.getSignature());
                CtMethod ctMethod2 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass2, null);
                String string3 = this.isThrowsSqlException(ctMethod) ? string.replace("method", ctMethod2.getName()) : "return ((cast) delegate).method($$);".replace("method", ctMethod2.getName()).replace("cast", clazz.getName());
                if (ctMethod2.getReturnType() == CtClass.voidType) {
                    string3 = string3.replace("return", "");
                }
                ctMethod2.setBody(string3);
                ctClass2.addMethod(ctMethod2);
            }
        }
        if (LoggerFactory.getLogger(this.getClass()).isDebugEnabled()) {
            ctClass2.debugWriteFile(System.getProperty("java.io.tmpdir"));
        }
        return ctClass2.toClass(this.classPool.getClassLoader(), null);
    }

    private boolean isThrowsSqlException(CtMethod ctMethod) {
        try {
            for (CtClass ctClass : ctMethod.getExceptionTypes()) {
                if (!ctClass.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavassistProxyFactory.class.getClassLoader());
            JavassistProxyFactory javassistProxyFactory = new JavassistProxyFactory();
            javassistProxyFactory.modifyProxyFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

