/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariMBeanElf;
import com.zaxxer.hikari.HikariPoolMBean;
import com.zaxxer.hikari.IConnectionCustomizer;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariPool
implements HikariPoolMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariPool.class);
    final DataSource dataSource;
    private final IConnectionCustomizer connectionCustomizer;
    private final HikariConfig configuration;
    private final LinkedBlockingQueue<IHikariConnectionProxy> idleConnections;
    private final Timer houseKeepingTimer;
    private final long leakDetectionThreshold;
    private final AtomicBoolean backgroundFillQueued;
    private final AtomicInteger idleConnectionCount;
    private final AtomicInteger totalConnections;
    private final AtomicInteger awaitingConnection;
    private final boolean isAutoCommit;
    private final boolean jdbc4ConnectionTest;
    private final boolean isRegisteredMbeans;
    private int transactionIsolation;
    private volatile boolean shutdown;
    private boolean debug;

    HikariPool(HikariConfig configuration) {
        configuration.validate();
        this.configuration = configuration;
        this.totalConnections = new AtomicInteger();
        this.idleConnectionCount = new AtomicInteger();
        this.awaitingConnection = new AtomicInteger();
        this.backgroundFillQueued = new AtomicBoolean();
        this.idleConnections = new LinkedBlockingQueue();
        this.jdbc4ConnectionTest = configuration.isJdbc4ConnectionTest();
        this.leakDetectionThreshold = configuration.getLeakDetectionThreshold();
        this.isAutoCommit = configuration.isAutoCommit();
        this.isRegisteredMbeans = configuration.isRegisterMbeans();
        this.transactionIsolation = configuration.getTransactionIsolation();
        this.debug = LOGGER.isDebugEnabled();
        if (configuration.getDataSource() == null) {
            String dsClassName = configuration.getDataSourceClassName();
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(dsClassName);
                this.dataSource = (DataSource)clazz.newInstance();
                PropertyBeanSetter.setTargetFromProperties(this.dataSource, configuration.getDataSourceProperties());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create datasource instance: " + dsClassName, e);
            }
        } else {
            this.dataSource = configuration.getDataSource();
        }
        if (configuration.getConnectionCustomizerClassName() != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(configuration.getConnectionCustomizerClassName());
                this.connectionCustomizer = (IConnectionCustomizer)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not load connection customization class", e);
            }
        } else {
            this.connectionCustomizer = null;
        }
        if (this.isRegisteredMbeans) {
            HikariMBeanElf.registerMBeans(configuration, this);
        }
        this.houseKeepingTimer = new Timer("Hikari Housekeeping Timer", true);
        this.fillPool();
        long idleTimeout = configuration.getIdleTimeout();
        if (idleTimeout > 0L || configuration.getMaxLifetime() > 0L) {
            long delayPeriod = Long.getLong("com.zaxxer.hikari.housekeeping.period", TimeUnit.SECONDS.toMillis(30L));
            this.houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeeper(), delayPeriod, delayPeriod);
        }
    }

    /*
     * Exception decompiling
     */
    Connection getConnection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseConnection(IHikariConnectionProxy connectionProxy) {
        if (!connectionProxy.isBrokenConnection() && !this.shutdown) {
            this.idleConnectionCount.incrementAndGet();
            if (!this.idleConnections.offer(connectionProxy)) {
                this.closeConnection(connectionProxy);
            }
        } else {
            LOGGER.debug("Connection returned to pool is broken, or the pool is shutting down.  Closing connection.");
            this.closeConnection(connectionProxy);
        }
    }

    void shutdown() {
        IHikariConnectionProxy connection;
        this.shutdown = true;
        this.houseKeepingTimer.cancel();
        while ((connection = this.idleConnections.poll()) != null) {
            this.closeConnection(connection);
        }
        HikariMBeanElf.unregisterMBeans(this.configuration, this);
    }

    @Override
    public int getActiveConnections() {
        return Math.min(this.configuration.getMaximumPoolSize(), this.totalConnections.get() - this.idleConnectionCount.get());
    }

    @Override
    public int getIdleConnections() {
        return this.idleConnectionCount.get();
    }

    @Override
    public int getTotalConnections() {
        return this.totalConnections.get();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.awaitingConnection.get();
    }

    @Override
    public void closeIdleConnections() {
        IHikariConnectionProxy connectionProxy;
        int idleCount = this.idleConnectionCount.get();
        for (int i = 0; i < idleCount && (connectionProxy = this.idleConnections.poll()) != null; ++i) {
            this.idleConnectionCount.decrementAndGet();
            this.closeConnection(connectionProxy);
        }
    }

    private void fillPool() {
        int maxIters = this.configuration.getMinimumPoolSize() * this.configuration.getAcquireRetries();
        while (this.totalConnections.get() < this.configuration.getMinimumPoolSize() && maxIters-- > 0) {
            int beforeCount = this.totalConnections.get();
            this.addConnection();
            if (!this.configuration.isInitializationFailFast() || beforeCount != this.totalConnections.get()) continue;
            throw new RuntimeException("Fail-fast during pool initialization");
        }
        this.logPoolState("Initial fill ");
    }

    private void addConnections(AddConnectionStrategy strategy) {
        switch (strategy) {
            case ONLY_IF_EMPTY: {
                if (this.idleConnectionCount.get() != 0) break;
                int max = this.configuration.getMaximumPoolSize();
                int increment = this.configuration.getAcquireIncrement();
                for (int i = 0; this.idleConnectionCount.get() < increment && i < increment && this.totalConnections.get() < max; ++i) {
                    this.addConnection();
                }
                break;
            }
            case MAINTAIN_MINIMUM: {
                int min = this.configuration.getMinimumPoolSize();
                int max = this.configuration.getMaximumPoolSize();
                int increment = this.configuration.getAcquireIncrement();
                for (int i = 0; this.totalConnections.get() < min && i < increment && this.totalConnections.get() < max; ++i) {
                    this.addConnection();
                }
                break;
            }
            case BACKGROUND_FILL: {
                if (this.idleConnectionCount.get() != 0 || !this.backgroundFillQueued.compareAndSet(false, true)) break;
                this.houseKeepingTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        int max = HikariPool.this.configuration.getMaximumPoolSize();
                        int increment = HikariPool.this.configuration.getAcquireIncrement();
                        while ((HikariPool.this.idleConnectionCount.get() < increment || HikariPool.this.awaitingConnection.get() > 0) && HikariPool.this.totalConnections.get() < max) {
                            HikariPool.this.addConnection();
                        }
                        HikariPool.this.backgroundFillQueued.set(false);
                    }
                }, 100L);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addConnection() {
        int retries = 0;
        while (true) {
            try {
                Connection connection = this.dataSource.getConnection();
                if (this.transactionIsolation < 0) {
                    this.transactionIsolation = connection.getTransactionIsolation();
                }
                if (this.connectionCustomizer != null) {
                    this.connectionCustomizer.customize(connection);
                }
                IHikariConnectionProxy proxyConnection = (IHikariConnectionProxy)ProxyFactory.getProxyConnection(this, connection, this.transactionIsolation);
                String initSql = this.configuration.getConnectionInitSql();
                if (initSql != null && initSql.length() > 0) {
                    connection.setAutoCommit(true);
                    try (Statement statement = connection.createStatement();){
                        statement.execute(initSql);
                    }
                }
                if (this.shutdown) return;
                this.idleConnectionCount.incrementAndGet();
                this.totalConnections.incrementAndGet();
                this.idleConnections.add(proxyConnection);
                return;
            }
            catch (Exception e) {
                if (retries++ > this.configuration.getAcquireRetries()) {
                    if (this.debug) {
                        LOGGER.error("Maximum connection creation retries exceeded: {}", (Object)e.getMessage(), (Object)e);
                        return;
                    } else {
                        LOGGER.error("Maximum connection creation retries exceeded: {}", (Object)e.getMessage());
                    }
                    return;
                }
                try {
                    Thread.sleep(this.configuration.getAcquireRetryDelay());
                }
                catch (InterruptedException e1) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnectionAlive(IHikariConnectionProxy connection, long timeoutMs) {
        try {
            connection.setAutoCommit(this.isAutoCommit);
            if (connection.isTransactionIsolationDirty()) {
                connection.setTransactionIsolation(this.transactionIsolation);
            }
            if (System.currentTimeMillis() - connection.getLastAccess() < 1000L) {
                return true;
            }
            try {
                if (timeoutMs < 1000L) {
                    timeoutMs = 1000L;
                }
                if (this.jdbc4ConnectionTest) {
                    boolean bl = connection.isValid((int)TimeUnit.MILLISECONDS.toSeconds(timeoutMs));
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    statement.setQueryTimeout((int)TimeUnit.MILLISECONDS.toSeconds(timeoutMs));
                    statement.executeQuery(this.configuration.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                if (!this.isAutoCommit) {
                    connection.commit();
                }
                connection.resetTransactionIsolationDirty();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Exception during keep alive check, that means the connection must be dead.", (Throwable)e);
            return false;
        }
    }

    private void closeConnection(IHikariConnectionProxy connectionProxy) {
        try {
            this.totalConnections.decrementAndGet();
            connectionProxy.realClose();
        }
        catch (SQLException e) {
            return;
        }
    }

    private void logPoolState(String ... prefix) {
        int total = this.totalConnections.get();
        int idle = this.idleConnectionCount.get();
        LOGGER.debug("{}Pool stats (total={}, inUse={}, avail={}, waiting={})", new Object[]{prefix.length > 0 ? prefix[0] : "", total, total - idle, idle, this.isRegisteredMbeans ? Integer.valueOf(this.awaitingConnection.get()) : "n/a"});
    }

    private static enum AddConnectionStrategy {
        ONLY_IF_EMPTY,
        BACKGROUND_FILL,
        MAINTAIN_MINIMUM;

    }

    private class HouseKeeper
    extends TimerTask {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            IHikariConnectionProxy connectionProxy;
            HikariPool.this.debug = LOGGER.isDebugEnabled();
            HikariPool.this.houseKeepingTimer.purge();
            HikariPool.this.logPoolState(new String[]{"Before pool cleanup "});
            long now = System.currentTimeMillis();
            long idleTimeout = HikariPool.this.configuration.getIdleTimeout();
            long maxLifetime = HikariPool.this.configuration.getMaxLifetime();
            int idleCount = HikariPool.this.idleConnectionCount.get();
            for (int i = 0; i < idleCount && (connectionProxy = (IHikariConnectionProxy)HikariPool.this.idleConnections.poll()) != null; ++i) {
                HikariPool.this.idleConnectionCount.decrementAndGet();
                if (idleTimeout > 0L && now > connectionProxy.getLastAccess() + idleTimeout || maxLifetime > 0L && now > connectionProxy.getCreationTime() + maxLifetime) {
                    HikariPool.this.closeConnection(connectionProxy);
                    continue;
                }
                HikariPool.this.idleConnectionCount.incrementAndGet();
                HikariPool.this.idleConnections.add(connectionProxy);
            }
            HikariPool.this.addConnections(AddConnectionStrategy.MAINTAIN_MINIMUM);
            HikariPool.this.logPoolState(new String[]{"After pool cleanup "});
        }
    }
}

