/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.HikariConfig;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyBeanSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyBeanSetter.class);

    public static void setTargetFromProperties(Object target, Properties properties) {
        if (target == null || properties == null) {
            return;
        }
        for (Object propKey : properties.keySet()) {
            String propName = propKey.toString();
            Object propValue = properties.get(propKey);
            if (target instanceof HikariConfig && propName.startsWith("dataSource.")) {
                HikariConfig config = (HikariConfig)target;
                config.addDataSourceProperty(propName.substring("dataSource.".length()), propValue);
                continue;
            }
            PropertyBeanSetter.setProperty(target, propName, propValue);
        }
    }

    private static void setProperty(Object target, String propName, Object propValue) {
        String capitalized = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propName, target.getClass(), null, capitalized);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            Class<?> paramClass = writeMethod.getParameterTypes()[0];
            if (paramClass == Integer.TYPE) {
                writeMethod.invoke(target, Integer.parseInt(propValue.toString()));
            } else if (paramClass == Long.TYPE) {
                writeMethod.invoke(target, Long.parseLong(propValue.toString()));
            } else if (paramClass == Boolean.TYPE) {
                writeMethod.invoke(target, Boolean.parseBoolean(propValue.toString()));
            } else if (paramClass == String.class) {
                writeMethod.invoke(target, propValue.toString());
            } else {
                writeMethod.invoke(target, propValue);
            }
        }
        catch (IntrospectionException e) {
            LOGGER.error("Property {} is does not exist on target class {}", (Object)propName, target.getClass());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOGGER.error("Exception setting property {} on target class {}", new Object[]{propName, target.getClass(), e});
            throw new RuntimeException(e);
        }
    }
}

