/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfigMBean;
import com.zaxxer.hikari.IConnectionCustomizer;
import com.zaxxer.hikari.proxy.JavassistProxyFactory;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariConfig
implements HikariConfigMBean {
    private static final long ACQUIRE_RETRY_DELAY = 750L;
    private static final long CONNECTION_TIMEOUT = 5000L;
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static int poolNumber;
    private volatile int acquireIncrement = 1;
    private volatile int acquireRetries = 3;
    private volatile long acquireRetryDelay = 750L;
    private volatile long connectionTimeout = 5000L;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int maxPoolSize = 60;
    private volatile int minPoolSize = 10;
    private String transactionIsolationName;
    private String connectionCustomizerClassName;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String catalog;
    private String poolName;
    private boolean isAutoCommit = true;
    private boolean isInitializationFailFast;
    private boolean isJdbc4connectionTest = true;
    private boolean isRegisterMbeans;
    private DataSource dataSource;
    private Properties dataSourceProperties = new Properties();
    private IConnectionCustomizer connectionCustomizer;
    private int transactionIsolation = -1;

    public HikariConfig() {
        this.idleTimeout = IDLE_TIMEOUT;
        this.maxLifetime = MAX_LIFETIME;
        this.poolName = "HikariPool-" + poolNumber++;
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyBeanSetter.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String propertyFileName) {
        this();
        File propFile = new File(propertyFileName);
        if (!propFile.isFile()) {
            throw new IllegalArgumentException("Property file " + propertyFileName + " was not found.");
        }
        try {
            FileInputStream fis = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(fis);
            PropertyBeanSetter.setTargetFromProperties(this, props);
            fis.close();
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading properties file", io);
        }
    }

    @Override
    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    @Override
    public void setAcquireIncrement(int acquireIncrement) {
        if (acquireIncrement < 1) {
            throw new IllegalArgumentException("acquireRetries cannot be less than 1");
        }
        this.acquireIncrement = acquireIncrement;
    }

    @Override
    public int getAcquireRetries() {
        return this.acquireRetries;
    }

    @Override
    public void setAcquireRetries(int acquireRetries) {
        if (acquireRetries < 0) {
            throw new IllegalArgumentException("acquireRetries cannot be negative");
        }
        this.acquireRetries = acquireRetries;
    }

    @Override
    public long getAcquireRetryDelay() {
        return this.acquireRetryDelay;
    }

    @Override
    public void setAcquireRetryDelay(long acquireRetryDelayMs) {
        if (acquireRetryDelayMs < 0L) {
            throw new IllegalArgumentException("acquireRetryDelay cannot be negative");
        }
        this.acquireRetryDelay = acquireRetryDelayMs;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getConnectionCustomizerClassName() {
        return this.connectionCustomizerClassName;
    }

    public void setConnectionCustomizerClassName(String connectionCustomizerClassName) {
        this.connectionCustomizerClassName = connectionCustomizerClassName;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (connectionTimeoutMs < 100L) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than 100ms");
            }
            this.connectionTimeout = connectionTimeoutMs;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    public void addDataSourceProperty(String propertyName, Object value) {
        this.dataSourceProperties.put(propertyName, value);
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties dsProperties) {
        this.dataSourceProperties.putAll((Map<?, ?>)dsProperties);
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        this.idleTimeout = idleTimeoutMs;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isInitializationFailFast() {
        return this.isInitializationFailFast;
    }

    public void setInitializationFailFast(boolean failFast) {
        this.isInitializationFailFast = failFast;
    }

    public boolean isJdbc4ConnectionTest() {
        return this.isJdbc4connectionTest;
    }

    public void setJdbc4ConnectionTest(boolean useIsValid) {
        this.isJdbc4connectionTest = useIsValid;
    }

    public boolean isRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public void setRegisterMbeans(boolean register) {
        this.isRegisterMbeans = register;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    public void setUseInstrumentation(boolean useInstrumentation) {
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @Override
    public int getMinimumPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinimumPoolSize(int minPoolSize) {
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("minPoolSize cannot be negative");
        }
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("maxPoolSize cannot be negative");
        }
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolationName = isolationLevel;
    }

    public void validate() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (this.acquireRetryDelay < 0L) {
            logger.error("acquireRetryDelay cannot be negative.");
            throw new IllegalStateException("acquireRetryDelay cannot be negative.");
        }
        if (this.acquireRetryDelay < 100L) {
            logger.warn("acquireRetryDelay is less than 100ms, did you specify the wrong time unit?  Using default instead.");
            this.acquireRetryDelay = 750L;
        }
        if (this.connectionCustomizerClassName != null && this.connectionCustomizer == null) {
            try {
                Class<?> customizerClass = this.getClass().getClassLoader().loadClass(this.connectionCustomizerClassName);
                this.connectionCustomizer = (IConnectionCustomizer)customizerClass.newInstance();
            }
            catch (Exception e) {
                logger.warn("connectionCustomizationClass specified class '" + this.connectionCustomizerClassName + "' could not be loaded", (Throwable)e);
                this.connectionCustomizerClassName = null;
            }
        }
        if (this.connectionTimeout == Integer.MAX_VALUE) {
            logger.warn("No connection wait timeout is set, this might cause an infinite wait.");
        } else if (this.connectionTimeout < 100L) {
            logger.warn("connectionTimeout is less than 100ms, did you specify the wrong time unit?  Using default instead.");
            this.connectionTimeout = 5000L;
        }
        if (this.dataSource == null && this.dataSourceClassName == null) {
            logger.error("one of either dataSource or dataSourceClassName must be specified");
            throw new IllegalStateException("one of either dataSource or dataSourceClassName must be specified");
        }
        if (this.dataSource != null && this.dataSourceClassName != null) {
            logger.warn("both dataSource and dataSourceClassName are specified, ignoring dataSourceClassName");
        }
        if (this.idleTimeout < 0L) {
            logger.error("idleTimeout cannot be negative.");
            throw new IllegalStateException("idleTimeout cannot be negative.");
        }
        if (this.idleTimeout < 30000L && this.idleTimeout != 0L) {
            logger.warn("idleTimeout is less than 30000ms, did you specify the wrong time unit?  Using default instead.");
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (!this.isJdbc4connectionTest && this.connectionTestQuery == null) {
            logger.error("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified.");
            throw new IllegalStateException("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified.");
        }
        if (this.leakDetectionThreshold != 0L && this.leakDetectionThreshold < 10000L) {
            logger.warn("leakDetectionThreshold is less than 10000ms, did you specify the wrong time unit?  Disabling leak detection.");
            this.leakDetectionThreshold = 0L;
        }
        if (this.maxPoolSize < this.minPoolSize) {
            logger.warn("maxPoolSize is less than minPoolSize, forcing them equal.");
            this.maxPoolSize = this.minPoolSize;
        }
        if (this.maxLifetime < 0L) {
            logger.error("maxLifetime cannot be negative.");
            throw new IllegalStateException("maxLifetime cannot be negative.");
        }
        if (this.maxLifetime < 120000L && this.maxLifetime != 0L) {
            logger.warn("maxLifetime is less than 120000ms, did you specify the wrong time unit?  Using default instead.");
            this.maxLifetime = MAX_LIFETIME;
        }
        if (this.transactionIsolationName != null) {
            try {
                int level;
                Field field = Connection.class.getField(this.transactionIsolationName);
                this.transactionIsolation = level = field.getInt(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid transaction isolation value: " + this.transactionIsolationName);
            }
        }
    }

    IConnectionCustomizer getConnectionCustomizer() {
        return this.connectionCustomizer;
    }

    void copyState(HikariConfig other) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(other, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Exception copying HikariConfig state: " + e.getMessage(), e);
            }
        }
    }

    static {
        JavassistProxyFactory.initialize();
    }
}

