/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.hibernate;

import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";
    public static final String CONFIG_PREFIX_DATASOURCE = "hibernate.hikari.dataSource.";

    public static HikariConfig loadConfiguration(Map props) {
        Properties hicaryProps = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.isolation", props, "transactionIsolation", hicaryProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", props, "autoCommit", hicaryProps);
        for (Object keyo : props.keySet()) {
            String key = (String)keyo;
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hicaryProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props.get(key));
        }
        return new HikariConfig(hicaryProps);
    }

    private static void copyProperty(String srcKey, Map src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }
}

