/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.pool.HikariPool;

public final class CodaHaleMetricsTracker
extends MetricsTracker {
    private MetricRegistry registry = new MetricRegistry();
    private Timer connectionObtainTimer = this.registry.timer(MetricRegistry.name(HikariPool.class, (String[])new String[]{"connection", "wait"}));
    private Histogram connectionUsage = this.registry.histogram(MetricRegistry.name(HikariPool.class, (String[])new String[]{"connection", "usage"}));

    public CodaHaleMetricsTracker(String poolName) {
    }

    @Override
    public Context recordConnectionRequest(long requestTime) {
        return new Context(this.connectionObtainTimer);
    }

    @Override
    public void recordConnectionUsage(long usageMilleseconds) {
        this.connectionUsage.update(usageMilleseconds);
    }

    public static final class Context
    extends MetricsTracker.Context {
        Timer.Context innerContext;

        Context(Timer timer) {
            this.innerContext = timer.time();
        }

        @Override
        public void stop() {
            if (this.innerContext != null) {
                this.innerContext.stop();
            }
        }
    }
}

