/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPoolMBean;
import com.zaxxer.hikari.IConnectionCustomizer;
import com.zaxxer.hikari.metrics.CodaHaleMetricsTracker;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.pool.HikariMBeanElf;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.DriverDataSource;
import com.zaxxer.hikari.util.PoolUtilities;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariPool
implements HikariPoolMBean,
ConcurrentBag.IBagStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariPool.class);
    private final DataSource dataSource;
    private final IConnectionCustomizer connectionCustomizer;
    private final HikariConfig configuration;
    private final ConcurrentBag<IHikariConnectionProxy> connectionBag;
    private final ThreadPoolExecutor addConnectionExecutor;
    private final MetricsTracker metricsTracker;
    private final boolean isAutoCommit;
    private final boolean isIsolateInternalQueries;
    private final boolean isReadOnly;
    private final boolean isRegisteredMbeans;
    private final boolean isJdbc4ConnectionTest;
    private final long leakDetectionThreshold;
    private final AtomicReference<Throwable> lastConnectionFailure;
    private final AtomicInteger totalConnections;
    private final Timer houseKeepingTimer;
    private final String catalog;
    private final String username;
    private final String password;
    private volatile boolean isShutdown;
    private int transactionIsolation;
    private boolean isDebug;

    public HikariPool(HikariConfig configuration) {
        this(configuration, configuration.getUsername(), configuration.getPassword());
    }

    public HikariPool(HikariConfig configuration, String username, String password) {
        this.configuration = configuration;
        this.username = username;
        this.password = password;
        this.totalConnections = new AtomicInteger();
        this.connectionBag = new ConcurrentBag();
        this.connectionBag.addBagStateListener(this);
        this.isDebug = LOGGER.isDebugEnabled();
        this.lastConnectionFailure = new AtomicReference();
        this.catalog = configuration.getCatalog();
        this.connectionCustomizer = this.initializeCustomizer();
        this.isAutoCommit = configuration.isAutoCommit();
        this.isIsolateInternalQueries = configuration.isIsolateInternalQueries();
        this.isReadOnly = configuration.isReadOnly();
        this.isRegisteredMbeans = configuration.isRegisterMbeans();
        this.isJdbc4ConnectionTest = configuration.isJdbc4ConnectionTest();
        this.leakDetectionThreshold = configuration.getLeakDetectionThreshold();
        this.transactionIsolation = configuration.getTransactionIsolation();
        this.metricsTracker = configuration.isRecordMetrics() ? new CodaHaleMetricsTracker(configuration.getPoolName()) : new MetricsTracker();
        this.dataSource = this.initializeDataSource();
        if (this.isRegisteredMbeans) {
            HikariMBeanElf.registerMBeans(configuration, this);
        }
        this.houseKeepingTimer = new Timer("Hikari Housekeeping Timer", true);
        this.addConnectionExecutor = PoolUtilities.createThreadPoolExecutor(configuration.getMaximumPoolSize(), "HikariCP connection filler");
        this.fillPool();
        if (configuration.getIdleTimeout() > 0L || configuration.getMaxLifetime() > 0L) {
            long delayPeriod = Long.getLong("com.zaxxer.hikari.housekeeping.period", TimeUnit.SECONDS.toMillis(30L));
            this.houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeeper(), delayPeriod, delayPeriod);
        }
    }

    /*
     * Exception decompiling
     */
    public Connection getConnection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseConnection(IHikariConnectionProxy connectionProxy) {
        this.metricsTracker.recordConnectionUsage(System.currentTimeMillis() - connectionProxy.getLastOpenTime());
        if (!connectionProxy.isBrokenConnection() && !this.isShutdown) {
            this.connectionBag.requite(connectionProxy);
        } else {
            LOGGER.debug("Connection returned to pool {} is broken, or the pool is shutting down.  Closing connection.", (Object)this.configuration.getPoolName());
            this.closeConnection(connectionProxy);
        }
    }

    public String toString() {
        return this.configuration.getPoolName();
    }

    public void shutdown() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.houseKeepingTimer.cancel();
            this.addConnectionExecutor.shutdown();
            LOGGER.info("HikariCP pool {} is being shutdown.", (Object)this.configuration.getPoolName());
            this.logPoolState("State at shutdown ");
            this.closeIdleConnections();
            if (this.isRegisteredMbeans) {
                HikariMBeanElf.unregisterMBeans(this.configuration, this);
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(IHikariConnectionProxy connectionProxy) {
        try {
            int tc = this.totalConnections.decrementAndGet();
            if (tc < 0) {
                LOGGER.warn("Internal accounting inconsistency, totalConnections=" + tc, (Throwable)new Exception());
            }
            connectionProxy.realClose();
        }
        catch (SQLException e) {
            return;
        }
        finally {
            this.connectionBag.remove(connectionProxy);
        }
    }

    @Override
    public void addBagItem() {
        class AddConnection
        implements Runnable {
            AddConnection() {
            }

            @Override
            public void run() {
                int minIdle;
                int sleepBackoff = 200;
                while (HikariPool.this.totalConnections.get() < HikariPool.this.configuration.getMaximumPoolSize() && ((minIdle = HikariPool.this.configuration.getMinimumIdle()) == 0 || HikariPool.this.getIdleConnections() < minIdle)) {
                    if (!HikariPool.this.addConnection()) {
                        PoolUtilities.quietlySleep(sleepBackoff);
                        sleepBackoff = (int)Math.min(1000.0, (double)sleepBackoff * 1.5);
                        if (HikariPool.this.getThreadsAwaitingConnection() != 0) continue;
                        HikariPool.this.lastConnectionFailure.set(null);
                        break;
                    }
                    if (minIdle != 0) continue;
                    break;
                }
            }
        }
        this.addConnectionExecutor.submit(new AddConnection());
    }

    @Override
    public int getActiveConnections() {
        return Math.min(this.configuration.getMaximumPoolSize(), this.totalConnections.get() - this.getIdleConnections());
    }

    @Override
    public int getIdleConnections() {
        return this.connectionBag.getCount(0);
    }

    @Override
    public int getTotalConnections() {
        return this.totalConnections.get();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.connectionBag.getPendingQueue();
    }

    @Override
    public void closeIdleConnections() {
        List<IHikariConnectionProxy> list = this.connectionBag.values(0);
        for (IHikariConnectionProxy connectionProxy : list) {
            if (!this.connectionBag.reserve(connectionProxy)) continue;
            this.closeConnection(connectionProxy);
        }
    }

    private boolean addConnection() {
        Connection connection = null;
        try {
            if (this.totalConnections.incrementAndGet() > this.configuration.getMaximumPoolSize()) {
                this.totalConnections.decrementAndGet();
                return true;
            }
            connection = this.username == null && this.password == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.username, this.password);
            int n = this.transactionIsolation = this.transactionIsolation < 0 ? connection.getTransactionIsolation() : this.transactionIsolation;
            if (this.connectionCustomizer != null) {
                this.connectionCustomizer.customize(connection);
            }
            PoolUtilities.executeSqlAutoCommit(connection, this.configuration.getConnectionInitSql());
            IHikariConnectionProxy proxyConnection = ProxyFactory.getProxyConnection(this, connection, this.transactionIsolation, this.isAutoCommit, this.isReadOnly, this.catalog);
            proxyConnection.resetConnectionState();
            this.connectionBag.add(proxyConnection);
            this.lastConnectionFailure.set(null);
            return true;
        }
        catch (Exception e) {
            this.totalConnections.decrementAndGet();
            if (connection != null) {
                PoolUtilities.quietlyCloseConnection(connection);
            }
            this.lastConnectionFailure.set(e);
            if (this.isDebug) {
                LOGGER.warn("Connection attempt to database {} failed (not every attempt is logged): {}", new Object[]{this.configuration.getPoolName(), e.getMessage(), this.isDebug ? e : null});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive(IHikariConnectionProxy connection, long timeoutMs) {
        try {
            timeoutMs = Math.max(1000L, timeoutMs);
            boolean valid = true;
            if (this.isJdbc4ConnectionTest) {
                valid = connection.isValid((int)TimeUnit.MILLISECONDS.toSeconds(timeoutMs));
            } else {
                Statement statement = connection.createStatement();
                try {
                    if (this.configuration.getConnectionTimeout() < Integer.MAX_VALUE) {
                        statement.setQueryTimeout((int)TimeUnit.MILLISECONDS.toSeconds(timeoutMs));
                    }
                    statement.executeQuery(this.configuration.getConnectionTestQuery());
                }
                finally {
                    statement.close();
                }
            }
            if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                connection.rollback();
            }
            return valid;
        }
        catch (SQLException e) {
            LOGGER.warn("Exception during keep alive check, that means the connection must be dead.", (Throwable)e);
            return false;
        }
    }

    private void fillPool() {
        if (this.configuration.isInitializationFailFast()) {
            for (int maxIters = this.configuration.getMinimumIdle(); maxIters > 0; --maxIters) {
                if (this.addConnection()) continue;
                throw new RuntimeException("Fail-fast during pool initialization", this.lastConnectionFailure.getAndSet(null));
            }
        } else if (this.configuration.getMinimumIdle() > 0) {
            this.addBagItem();
        }
    }

    private DataSource initializeDataSource() {
        String dsClassName = this.configuration.getDataSourceClassName();
        if (this.configuration.getDataSource() == null && dsClassName != null) {
            try {
                DataSource dataSource = PoolUtilities.createInstance(dsClassName, DataSource.class);
                PropertyBeanSetter.setTargetFromProperties(dataSource, this.configuration.getDataSourceProperties());
                return dataSource;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create datasource instance: " + dsClassName, e);
            }
        }
        if (this.configuration.getJdbcUrl() != null) {
            return new DriverDataSource(this.configuration.getJdbcUrl(), this.configuration.getDataSourceProperties(), this.username, this.password);
        }
        return this.configuration.getDataSource();
    }

    private IConnectionCustomizer initializeCustomizer() {
        if (this.configuration.getConnectionCustomizerClassName() != null) {
            try {
                return PoolUtilities.createInstance(this.configuration.getConnectionCustomizerClassName(), IConnectionCustomizer.class);
            }
            catch (Exception e) {
                LOGGER.error("Connection customizer could not be created", (Throwable)e);
            }
        }
        return null;
    }

    private void logPoolState(String ... prefix) {
        int total = this.totalConnections.get();
        int idle = this.getIdleConnections();
        LOGGER.debug("{}Pool stats {} (total={}, inUse={}, avail={}, waiting={})", new Object[]{prefix.length > 0 ? prefix[0] : "", this.configuration.getPoolName(), total, total - idle, idle, this.getThreadsAwaitingConnection()});
    }

    private class HouseKeeper
    extends TimerTask {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            HikariPool.this.isDebug = LOGGER.isDebugEnabled();
            HikariPool.this.houseKeepingTimer.purge();
            HikariPool.this.logPoolState(new String[]{"Before pool cleanup "});
            long now = System.currentTimeMillis();
            long idleTimeout = HikariPool.this.configuration.getIdleTimeout();
            long maxLifetime = HikariPool.this.configuration.getMaxLifetime();
            for (IHikariConnectionProxy connectionProxy : HikariPool.this.connectionBag.values(0)) {
                if (!HikariPool.this.connectionBag.reserve(connectionProxy)) continue;
                if (idleTimeout > 0L && now > connectionProxy.getLastAccess() + idleTimeout || maxLifetime > 0L && now > connectionProxy.getCreationTime() + maxLifetime) {
                    HikariPool.this.closeConnection(connectionProxy);
                    continue;
                }
                HikariPool.this.connectionBag.unreserve(connectionProxy);
            }
            HikariPool.this.logPoolState(new String[]{"After pool cleanup "});
            if (HikariPool.this.getIdleConnections() < HikariPool.this.configuration.getMinimumIdle() && HikariPool.this.totalConnections.get() < HikariPool.this.configuration.getMaximumPoolSize()) {
                HikariPool.this.addBagItem();
            }
        }
    }
}

