/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.util.DefaultThreadFactory;
import com.zaxxer.hikari.util.DriverDataSource;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;

public final class PoolUtilities {
    private static volatile boolean IS_JDBC40;
    private static volatile boolean IS_JDBC41;
    private static volatile boolean jdbc40checked;
    private static volatile boolean jdbc41checked;
    private static volatile boolean queryTimeoutSupported;

    public static void quietlyCloseConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    public static long elapsedTimeMs(long start) {
        return System.currentTimeMillis() - start;
    }

    public static void executeSqlAutoCommit(Connection connection, String sql) throws SQLException {
        if (sql != null) {
            connection.setAutoCommit(true);
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
    }

    public static void quietlySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(String className, Class<T> clazz, Object ... args) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> loaded = PoolUtilities.class.getClassLoader().loadClass(className);
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            if (args.length > 0) {
                Constructor<?> constructor = loaded.getConstructor(argClasses);
                return (T)constructor.newInstance(args);
            }
            return (T)loaded.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DataSource initializeDataSource(String dsClassName, DataSource dataSource, Properties dataSourceProperties, String jdbcUrl, String username, String password) {
        if (dataSource == null && dsClassName != null) {
            dataSource = PoolUtilities.createInstance(dsClassName, DataSource.class, new Object[0]);
            PropertyBeanSetter.setTargetFromProperties(dataSource, dataSourceProperties);
            return dataSource;
        }
        if (jdbcUrl != null) {
            return new DriverDataSource(jdbcUrl, dataSourceProperties, username, password);
        }
        return dataSource;
    }

    public static int getTransactionIsolation(String transactionIsolationName) {
        if (transactionIsolationName != null) {
            try {
                Field field = Connection.class.getField(transactionIsolationName);
                return field.getInt(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid transaction isolation value: " + transactionIsolationName);
            }
        }
        return -1;
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int queueSize, String threadName, ThreadFactory threadFactory, RejectedExecutionHandler policy) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(threadName, true);
        }
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, queue, threadFactory, policy);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static boolean isJdbc40Compliant(Connection connection) throws SQLException {
        if (jdbc40checked) {
            return IS_JDBC40;
        }
        try {
            connection.isValid(100);
            IS_JDBC40 = true;
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            IS_JDBC40 = false;
        }
        jdbc40checked = true;
        return IS_JDBC40;
    }

    public static boolean isJdbc41Compliant(Connection connection) throws SQLException {
        if (jdbc41checked) {
            return IS_JDBC41;
        }
        try {
            connection.getNetworkTimeout();
            IS_JDBC41 = true;
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            IS_JDBC41 = false;
        }
        jdbc41checked = true;
        return IS_JDBC41;
    }

    public static void setQueryTimeout(Statement statement, int timeoutSec) throws SQLException {
        if (queryTimeoutSupported) {
            try {
                statement.setQueryTimeout(timeoutSec);
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                queryTimeoutSupported = false;
            }
        }
    }

    public static int setNetworkTimeout(Executor executor, Connection connection, long timeoutMs, boolean isUseNetworkTimeout) throws SQLException {
        if (!isUseNetworkTimeout) {
            return 0;
        }
        int networkTimeout = connection.getNetworkTimeout();
        connection.setNetworkTimeout(executor, Math.max(250, (int)timeoutMs));
        return networkTimeout;
    }

    public static void setLoginTimeout(DataSource dataSource, long connectionTimeout, Logger logger) {
        if (connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(Math.min(1000L, connectionTimeout)));
            }
            catch (SQLException e) {
                logger.warn("Unable to set DataSource login timeout", (Throwable)e);
            }
        }
    }

    static {
        queryTimeoutSupported = true;
    }
}

