/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.PoolBagEntry;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeakTask.class);
    private static final LeakTask NO_LEAK = new LeakTask(){

        @Override
        public void cancel() {
        }
    };
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;
    private ScheduledFuture<?> scheduledFuture;
    private String connectionName;
    private Exception exception;

    LeakTask(long leakDetectionThreshold, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    private LeakTask(LeakTask parent, PoolBagEntry bagEntry) {
        this.exception = new Exception("Apparent connection leak detected");
        this.connectionName = bagEntry.connection.toString();
        this.scheduledFuture = parent.executorService.schedule(this, parent.leakDetectionThreshold, TimeUnit.MILLISECONDS);
    }

    private LeakTask() {
    }

    LeakTask start(PoolBagEntry bagEntry) {
        return this.leakDetectionThreshold == 0L ? NO_LEAK : new LeakTask(this, bagEntry);
    }

    void updateLeakDetectionThreshold(long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    @Override
    public void run() {
        StackTraceElement[] stackTrace = this.exception.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[stackTrace.length - 5];
        System.arraycopy(stackTrace, 5, trace, 0, trace.length);
        this.exception.setStackTrace(trace);
        LOGGER.warn("Connection leak detection triggered for connection {}, stack trace follows", (Object)this.connectionName, (Object)this.exception);
    }

    public void cancel() {
        this.scheduledFuture.cancel(false);
    }
}

