/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.PoolElf;
import com.zaxxer.hikari.util.ClockSource;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.FastList;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoolBagEntry
implements ConcurrentBag.IConcurrentBagEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolBagEntry.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, HH:mm:ss.SSS");
    public final FastList<Statement> openStatements;
    public final HikariPool parentPool;
    public final long creationTime;
    public Connection connection;
    public long lastAccess;
    public volatile long lastOpenTime;
    public volatile boolean evicted;
    public volatile boolean aborted;
    public boolean isAutoCommit;
    int networkTimeout;
    int transactionIsolation;
    String catalog;
    boolean isReadOnly;
    private final PoolElf poolElf;
    private final AtomicInteger state;
    private volatile ScheduledFuture<?> endOfLife;

    public PoolBagEntry(Connection connection, final HikariPool pool) {
        this.connection = connection;
        this.parentPool = pool;
        this.creationTime = System.currentTimeMillis();
        this.poolElf = pool.poolElf;
        this.state = new AtomicInteger(0);
        this.lastAccess = ClockSource.INSTANCE.currentTime();
        this.openStatements = new FastList(Statement.class, 16);
        this.poolElf.resetPoolEntry(this);
        long maxLifetime = pool.config.getMaxLifetime();
        long variance = maxLifetime > 60000L ? ThreadLocalRandom.current().nextLong(10000L) : 0L;
        long lifetime = maxLifetime - variance;
        if (lifetime > 0L) {
            this.endOfLife = pool.houseKeepingExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    if (pool.connectionBag.reserve(PoolBagEntry.this)) {
                        pool.closeConnection(PoolBagEntry.this, "(connection reached maxLifetime)");
                    } else {
                        PoolBagEntry.this.evicted = true;
                    }
                }
            }, lifetime, TimeUnit.MILLISECONDS);
        }
    }

    public void releaseConnection(long lastAccess) {
        this.lastAccess = lastAccess;
        this.parentPool.releaseConnection(this);
    }

    public void resetConnectionState() throws SQLException {
        this.poolElf.resetConnectionState(this);
        this.poolElf.resetPoolEntry(this);
    }

    public void setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public AtomicInteger state() {
        return this.state;
    }

    public String toString() {
        return String.format("%s (created %s, last release %dms ago, %s)", this.connection, PoolBagEntry.formatDateTime(this.creationTime), ClockSource.INSTANCE.elapsedMillis(this.lastAccess), this.stateToString());
    }

    void cancelMaxLifeTermination() {
        if (this.endOfLife != null && !this.endOfLife.isDone() && !this.endOfLife.cancel(false)) {
            LOGGER.warn("{} - maxLifeTime expiration task cancellation unexpectedly returned false for connection {}", (Object)this.parentPool.config.getPoolName(), (Object)this.connection);
        }
        this.endOfLife = null;
        this.parentPool.houseKeepingExecutorService.purge();
    }

    private static synchronized String formatDateTime(long timestamp) {
        return DATE_FORMAT.format(new Date(timestamp));
    }

    private String stateToString() {
        switch (this.state.get()) {
            case 1: {
                return "IN_USE";
            }
            case 0: {
                return "NOT_IN_USE";
            }
            case -1: {
                return "REMOVED";
            }
            case -2: {
                return "RESERVED";
            }
        }
        return "Invalid";
    }
}

