/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.HikariConfig;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyElf.class);

    public static void setTargetFromProperties(Object target, Properties properties) {
        if (target == null || properties == null) {
            return;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            String propName = key.toString();
            Object propValue = properties.getProperty(propName);
            if (propValue == null) {
                propValue = properties.get(key);
            }
            if (target instanceof HikariConfig && propName.startsWith("dataSource.")) {
                HikariConfig config = (HikariConfig)target;
                config.addDataSourceProperty(propName.substring("dataSource.".length()), propValue);
                continue;
            }
            PropertyElf.setProperty(target, propName, propValue);
        }
    }

    public static Set<String> getPropertyNames(Class<?> targetClass) {
        HashSet<String> set = new HashSet<String>();
        try {
            BeanInfo info = Introspector.getBeanInfo(targetClass);
            for (PropertyDescriptor descr : info.getPropertyDescriptors()) {
                if ("class".equals(descr.getName())) continue;
                set.add(descr.getName());
            }
            return set;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getProperty(String propName, Object target) {
        try {
            String capitalized = "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Method method = target.getClass().getMethod(capitalized, new Class[0]);
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            try {
                String capitalized = "is" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                Method method = target.getClass().getMethod(capitalized, new Class[0]);
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Properties copyProperties(Properties props) {
        Properties copy = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            copy.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public static void flushCaches() {
        Introspector.flushCaches();
    }

    private static void setProperty(Object target, String propName, Object propValue) {
        PropertyDescriptor propertyDescriptor;
        String capitalized = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        try {
            propertyDescriptor = new PropertyDescriptor(propName, target.getClass(), null, capitalized);
        }
        catch (IntrospectionException e) {
            capitalized = "set" + propName.toUpperCase();
            try {
                propertyDescriptor = new PropertyDescriptor(propName, target.getClass(), null, capitalized);
            }
            catch (IntrospectionException e1) {
                LOGGER.error("Property {} does not exist on target {}", (Object)propName, target.getClass());
                throw new RuntimeException(e);
            }
        }
        try {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            Class<?> paramClass = writeMethod.getParameterTypes()[0];
            if (paramClass == Integer.TYPE) {
                writeMethod.invoke(target, Integer.parseInt(propValue.toString()));
            } else if (paramClass == Long.TYPE) {
                writeMethod.invoke(target, Long.parseLong(propValue.toString()));
            } else if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                writeMethod.invoke(target, Boolean.parseBoolean(propValue.toString()));
            } else if (paramClass == String.class) {
                writeMethod.invoke(target, propValue.toString());
            } else {
                writeMethod.invoke(target, propValue);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception setting property {} on target {}", new Object[]{propName, target.getClass(), e});
            throw new RuntimeException(e);
        }
    }
}

