/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm;

import com.zaxxer.sansorm.SqlClosureElf;
import com.zaxxer.sansorm.TransactionElf;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlClosure<T> {
    private static DataSource defaultDataSource;
    private List<Statement> closeStatements = new ArrayList<Statement>();
    private List<ResultSet> closeResultSets = new ArrayList<ResultSet>();
    private Object[] args;
    private DataSource dataSource;

    public SqlClosure() {
        this.dataSource = defaultDataSource;
        if (this.dataSource == null) {
            throw new RuntimeException("No default DataSource has been set");
        }
    }

    public SqlClosure(Object ... args) {
        this.args = args;
    }

    public SqlClosure(DataSource ds) {
        this.dataSource = ds;
    }

    public SqlClosure(DataSource ds, Object ... args) {
        this.dataSource = ds;
        this.args = args;
    }

    public static void setDefaultDataSource(DataSource ds) {
        defaultDataSource = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final T execute() {
        Connection connection;
        boolean owner;
        block20: {
            owner = TransactionElf.beginOrJoinTransaction();
            connection = null;
            connection = this.dataSource.getConnection();
            if (this.args == null) break block20;
            T t = this.execute(connection, this.args);
            Object var5_7 = null;
            for (ResultSet rs : this.closeResultSets) {
                SqlClosureElf.quietClose(rs);
            }
            for (Statement stmt : this.closeStatements) {
                SqlClosureElf.quietClose(stmt);
            }
            this.closeResultSets.clear();
            this.closeStatements.clear();
            try {
                if (owner) {
                    this.commit(connection);
                }
                Object var9_16 = null;
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                SqlClosureElf.quietClose(connection);
                throw throwable;
            }
            SqlClosureElf.quietClose(connection);
            return t;
        }
        T t = this.execute(connection);
        Object var5_8 = null;
        for (ResultSet rs : this.closeResultSets) {
            SqlClosureElf.quietClose(rs);
        }
        for (Statement stmt : this.closeStatements) {
            SqlClosureElf.quietClose(stmt);
        }
        this.closeResultSets.clear();
        this.closeStatements.clear();
        try {
            if (owner) {
                this.commit(connection);
            }
            Object var9_18 = null;
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            SqlClosureElf.quietClose(connection);
            throw throwable;
        }
        SqlClosureElf.quietClose(connection);
        return t;
        catch (SQLException e) {
            try {
                if (e.getNextException() != null) {
                    e = e.getNextException();
                }
                if (owner) {
                    this.rollback(connection);
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                for (ResultSet rs : this.closeResultSets) {
                    SqlClosureElf.quietClose(rs);
                }
                for (Statement stmt : this.closeStatements) {
                    SqlClosureElf.quietClose(stmt);
                }
                this.closeResultSets.clear();
                this.closeStatements.clear();
                try {
                    if (owner) {
                        this.commit(connection);
                    }
                    Object var9_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_21 = null;
                    SqlClosureElf.quietClose(connection);
                    throw throwable2;
                }
                SqlClosureElf.quietClose(connection);
                throw throwable;
            }
        }
    }

    public final T executeWith(Object ... args) {
        this.args = args;
        return this.execute();
    }

    protected final <S extends Statement> S autoClose(S statement) {
        if (statement != null) {
            this.closeStatements.add(statement);
        }
        return statement;
    }

    protected final ResultSet autoClose(ResultSet resultSet) {
        if (resultSet != null) {
            this.closeResultSets.add(resultSet);
        }
        return resultSet;
    }

    protected T execute(Connection connection) throws SQLException {
        return null;
    }

    protected T execute(Connection connection, Object ... args) throws SQLException {
        return null;
    }

    private void rollback(Connection connection) {
        if (TransactionElf.hasTransactionManager()) {
            TransactionElf.rollback();
        } else if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void commit(Connection connection) {
        if (TransactionElf.hasTransactionManager()) {
            TransactionElf.commit();
        } else if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

