/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm;

import com.zaxxer.sansorm.OrmElf;
import com.zaxxer.sansorm.SqlClosure;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlClosureElf {
    private SqlClosureElf() {
    }

    public static <T> T getObjectById(Class<T> type, Object ... ids) {
        return new ObjectByIdClosure<T>(type, ids).execute();
    }

    public static <T> T objectFromClause(Class<T> type, String clause, Object ... args) {
        return new ObjectFromClause<T>(type, clause, args).execute();
    }

    public static <T> T insertObject(T object) {
        return new InsertClosure<T>(object).execute();
    }

    public static <T> T updateObject(T object) {
        return new UpdateClosure<T>(object).execute();
    }

    public static <T> int deleteObject(T object) {
        return (Integer)new DeleteClosure<T>(object).execute();
    }

    public static <T> int deleteObjectById(Class<T> clazz, Object ... args) {
        return (Integer)new DeleteByIdClosure<T>(clazz, args).execute();
    }

    public static <T> List<T> listFromClause(Class<T> clazz, String clause, Object ... args) {
        return (List)new ListFromClauseClosure<T>(clazz, clause, args).execute();
    }

    public static <T> int countObjectsFromClause(Class<T> clazz, String clause, Object ... args) {
        return (Integer)new CountObjectsFromClause<T>(clazz, clause, args).execute();
    }

    public static int executeUpdate(final String sql, final Object ... args) {
        return (Integer)new SqlClosure<Integer>(){

            @Override
            protected Integer execute(Connection connection) throws SQLException {
                return OrmElf.executeUpdate(connection, sql, args);
            }
        }.execute();
    }

    public static void quietClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    public static void quietClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    public static void quietClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountObjectsFromClause<T>
    extends SqlClosure<Integer> {
        private Class<T> clazz;
        private String clause;
        private Object[] args;

        public CountObjectsFromClause(Class<T> clazz, String clause, Object[] args) {
            this.clazz = clazz;
            this.clause = clause;
            this.args = args;
        }

        @Override
        protected Integer execute(Connection connection) throws SQLException {
            return OrmElf.countObjectsFromClause(connection, this.clazz, this.clause, this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectByIdClosure<T>
    extends SqlClosure<T> {
        private Class<T> type;
        private Object[] ids;

        public ObjectByIdClosure(Class<T> type, Object[] ids) {
            this.type = type;
            this.ids = ids;
        }

        @Override
        protected T execute(Connection connection) throws SQLException {
            return OrmElf.objectById(connection, this.type, this.ids);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectFromClause<T>
    extends SqlClosure<T> {
        private Class<T> clazz;
        private String clause;
        private Object[] args;

        public ObjectFromClause(Class<T> clazz, String clause, Object[] args) {
            this.clause = clause;
            this.args = args;
            this.clazz = clazz;
        }

        @Override
        protected T execute(Connection connection) throws SQLException {
            return OrmElf.objectFromClause(connection, this.clazz, this.clause, this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteByIdClosure<T>
    extends SqlClosure<Integer> {
        private Class<T> clazz;
        private Object[] args;

        public DeleteByIdClosure(Class<T> clazz, Object ... args) {
            this.clazz = clazz;
            this.args = args;
        }

        @Override
        protected Integer execute(Connection connection) throws SQLException {
            return OrmElf.deleteObjectById(connection, this.clazz, this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteClosure<T>
    extends SqlClosure<Integer> {
        private T object;

        public DeleteClosure(T object) {
            this.object = object;
        }

        @Override
        protected Integer execute(Connection connection) throws SQLException {
            return OrmElf.deleteObject(connection, this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InsertClosure<T>
    extends SqlClosure<T> {
        private T object;

        public InsertClosure(T object) {
            this.object = object;
        }

        @Override
        protected T execute(Connection connection) throws SQLException {
            return OrmElf.insertObject(connection, this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateClosure<T>
    extends SqlClosure<T> {
        private T object;

        public UpdateClosure(T object) {
            this.object = object;
        }

        @Override
        protected T execute(Connection connection) throws SQLException {
            return OrmElf.updateObject(connection, this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListFromClauseClosure<T>
    extends SqlClosure<List<T>> {
        private Class<T> clazz;
        private String clause;
        private Object[] args;

        public ListFromClauseClosure(Class<T> clazz, String clause, Object[] args) {
            this.clazz = clazz;
            this.clause = clause;
            this.args = args;
        }

        @Override
        protected List<T> execute(Connection connection) throws SQLException {
            return OrmElf.listFromClause(connection, this.clazz, this.clause, this.args);
        }
    }
}

