/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionElf.class);
    private static TransactionManager transactionManager;
    private static UserTransaction userTransaction;

    public static void setTransactionManager(TransactionManager tm) {
        transactionManager = tm;
    }

    public static void setUserTransaction(UserTransaction ut) {
        userTransaction = ut;
    }

    public static boolean hasTransactionManager() {
        return transactionManager != null;
    }

    public static boolean beginOrJoinTransaction() {
        boolean newTransaction = false;
        try {
            boolean bl = newTransaction = userTransaction.getStatus() == 6;
            if (newTransaction) {
                userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start transaction.", e);
        }
        return newTransaction;
    }

    public static void commit() {
        try {
            int status = userTransaction.getStatus();
            if (status != 9 && status != 1 && status != 4 && status != 9 && status != 5 && status != 6 && status != 3) {
                userTransaction.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Transaction commit failed.", e);
        }
    }

    public static void rollback() {
        try {
            if (userTransaction.getStatus() == 0) {
                userTransaction.rollback();
            } else {
                LOGGER.warn("Request to rollback transaction when none was in active.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Transaction rollback failed.", (Throwable)e);
        }
    }

    public static Transaction suspend() {
        try {
            Transaction suspend = transactionManager.suspend();
            return suspend;
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to suspend current transaction", e);
        }
    }

    public static void resume(Transaction transaction) {
        try {
            transactionManager.resume(transaction);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resume transaction", e);
        }
    }
}

