/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspected {
    private Class<?> clazz;
    private String tableName;
    private Map<String, FieldColumnInfo> columnToField = new LinkedHashMap<String, FieldColumnInfo>();
    private FieldColumnInfo selfJoinFCInfo;
    private boolean isGeneratedId;
    private FieldColumnInfo[] idFieldColumnInfos;
    private String[] idColumnNames;
    private String[] columnNames;
    private String[] columnTableNames;
    private String[] columnsSansIds;
    private String[] insertableColumns;
    private String[] updatableColumns;

    Introspected(Class<?> clazz) {
        this.clazz = clazz;
        Table tableAnnotation = clazz.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            this.tableName = tableAnnotation.name();
        }
        try {
            ArrayList<FieldColumnInfo> idFcInfos = new ArrayList<FieldColumnInfo>();
            for (Field field : clazz.getDeclaredFields()) {
                Enumerated enumAnnotation;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers)) continue;
                field.setAccessible(true);
                FieldColumnInfo fcInfo = new FieldColumnInfo(field);
                this.processColumnAnnotation(fcInfo);
                Id idAnnotation = field.getAnnotation(Id.class);
                if (idAnnotation != null) {
                    idFcInfos.add(fcInfo);
                    GeneratedValue generatedAnnotation = field.getAnnotation(GeneratedValue.class);
                    boolean bl = this.isGeneratedId = generatedAnnotation != null;
                    if (this.isGeneratedId && idFcInfos.size() > 1) {
                        throw new IllegalStateException("Cannot have multiple @Id annotations and @GeneratedValue at the same time.");
                    }
                }
                if ((enumAnnotation = field.getAnnotation(Enumerated.class)) == null) continue;
                fcInfo.setEnumConstants(enumAnnotation.value());
            }
            this.readColumnInfo(idFcInfos);
            this.getInsertableColumns();
            this.getUpdatableColumns();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(Object target, String columnName) {
        FieldColumnInfo fcInfo = this.columnToField.get(columnName);
        if (fcInfo == null) {
            throw new RuntimeException("Cannot find field mapped to column " + columnName + " on type " + target.getClass().getCanonicalName());
        }
        try {
            Object value = fcInfo.field.get(target);
            if (fcInfo.enumConstants != null) {
                value = fcInfo.enumType == EnumType.ORDINAL ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object target, String columnName, Object value) {
        FieldColumnInfo fcInfo = this.columnToField.get(columnName);
        if (fcInfo == null) {
            throw new RuntimeException("Cannot find field mapped to column " + columnName + " on type " + target.getClass().getCanonicalName());
        }
        try {
            Class fieldType = fcInfo.fieldType;
            Class<?> columnType = value.getClass();
            Object columnValue = value;
            if (fieldType != columnType) {
                if (fieldType == Boolean.TYPE && columnType == Integer.class) {
                    columnValue = (Integer)columnValue != 0;
                } else if (columnType == BigDecimal.class) {
                    if (fieldType == BigInteger.class) {
                        columnValue = ((BigDecimal)columnValue).toBigInteger();
                    } else if (fieldType == Integer.class) {
                        columnValue = (int)((BigDecimal)columnValue).longValue();
                    } else if (fieldType == Long.class) {
                        columnValue = ((BigDecimal)columnValue).longValue();
                    }
                } else if (fcInfo.enumConstants != null) {
                    columnValue = fcInfo.enumConstants.get(columnValue);
                } else if (columnValue instanceof Clob) {
                    columnValue = this.readClob((Clob)columnValue);
                }
            }
            fcInfo.field.set(target, columnValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasSelfJoinColumn() {
        return this.selfJoinFCInfo != null;
    }

    public boolean isSelfJoinColumn(String columnName) {
        return this.selfJoinFCInfo.columnName.equals(columnName);
    }

    public String getSelfJoinColumn() {
        return this.selfJoinFCInfo != null ? this.selfJoinFCInfo.columnName : null;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getColumnTableNames() {
        return this.columnTableNames;
    }

    public String[] getIdColumnNames() {
        return this.idColumnNames;
    }

    public String[] getColumnsSansIds() {
        return this.columnsSansIds;
    }

    public boolean hasGeneratedId() {
        return this.isGeneratedId;
    }

    public String[] getInsertableColumns() {
        if (this.insertableColumns != null) {
            return this.insertableColumns;
        }
        LinkedList<String> columns = new LinkedList<String>();
        if (this.hasGeneratedId()) {
            columns.addAll(Arrays.asList(this.columnsSansIds));
        } else {
            columns.addAll(Arrays.asList(this.columnNames));
        }
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            if (this.isInsertableColumn((String)iterator.next())) continue;
            iterator.remove();
        }
        this.insertableColumns = columns.toArray(new String[0]);
        return this.insertableColumns;
    }

    public String[] getUpdatableColumns() {
        if (this.updatableColumns != null) {
            return this.updatableColumns;
        }
        LinkedList<String> columns = new LinkedList<String>();
        if (this.hasGeneratedId()) {
            columns.addAll(Arrays.asList(this.columnsSansIds));
        } else {
            columns.addAll(Arrays.asList(this.columnNames));
        }
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            if (this.isUpdatableColumn((String)iterator.next())) continue;
            iterator.remove();
        }
        this.updatableColumns = columns.toArray(new String[0]);
        return this.updatableColumns;
    }

    public boolean isInsertableColumn(String columnName) {
        FieldColumnInfo fcInfo = this.columnToField.get(columnName);
        return fcInfo != null && fcInfo.insertable;
    }

    public boolean isUpdatableColumn(String columnName) {
        FieldColumnInfo fcInfo = this.columnToField.get(columnName);
        return fcInfo != null && fcInfo.updatable;
    }

    public Object[] getActualIds(Object target) {
        if (this.idColumnNames.length == 0) {
            return null;
        }
        try {
            Object[] ids = new Object[this.idColumnNames.length];
            int i = 0;
            for (FieldColumnInfo fcInfo : this.idFieldColumnInfos) {
                ids[i++] = fcInfo.field.get(target);
            }
            return ids;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnNameForProperty(String propertyName) {
        for (FieldColumnInfo fcInfo : this.columnToField.values()) {
            if (!fcInfo.field.getName().equalsIgnoreCase(propertyName)) continue;
            return fcInfo.columnName;
        }
        return null;
    }

    private void readColumnInfo(ArrayList<FieldColumnInfo> idFcInfos) {
        this.idFieldColumnInfos = new FieldColumnInfo[idFcInfos.size()];
        this.idColumnNames = new String[idFcInfos.size()];
        int i = 0;
        int j = 0;
        for (FieldColumnInfo fieldColumnInfo : idFcInfos) {
            this.idColumnNames[i] = fieldColumnInfo.columnName;
            this.idFieldColumnInfos[i] = fieldColumnInfo;
            ++i;
        }
        this.columnNames = new String[this.columnToField.size()];
        this.columnTableNames = new String[this.columnNames.length];
        this.columnsSansIds = new String[this.columnNames.length - this.idColumnNames.length];
        i = 0;
        j = 0;
        for (Map.Entry entry : this.columnToField.entrySet()) {
            this.columnNames[i] = (String)entry.getKey();
            this.columnTableNames[i] = ((FieldColumnInfo)entry.getValue()).columnTableName;
            if (!idFcInfos.contains(entry.getValue())) {
                this.columnsSansIds[j] = (String)entry.getKey();
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readClob(Clob clob) throws IOException, SQLException {
        Reader reader = clob.getCharacterStream();
        try {
            int rc;
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[1024];
            while ((rc = reader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, rc);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processColumnAnnotation(FieldColumnInfo fcInfo) {
        Field field = fcInfo.field;
        Column columnAnnotation = field.getAnnotation(Column.class);
        if (columnAnnotation != null) {
            fcInfo.columnName = columnAnnotation.name().toLowerCase();
            String columnTableName = columnAnnotation.table();
            if (columnTableName != null && columnTableName.length() > 0) {
                fcInfo.columnTableName = columnTableName.toLowerCase();
            }
            fcInfo.insertable = columnAnnotation.insertable();
            fcInfo.updatable = columnAnnotation.updatable();
        } else {
            JoinColumn joinColumnAnnotation = field.getAnnotation(JoinColumn.class);
            if (joinColumnAnnotation != null) {
                if (field.getType() != this.clazz) throw new RuntimeException("JoinColumn annotations can only be self-referencing: " + field.getType().getCanonicalName() + " != " + this.clazz.getCanonicalName());
                fcInfo.columnName = joinColumnAnnotation.name().toLowerCase();
                this.selfJoinFCInfo = fcInfo;
            } else {
                fcInfo.columnName = field.getName().toLowerCase();
            }
        }
        Transient transientAnnotation = field.getAnnotation(Transient.class);
        if (transientAnnotation != null) return;
        this.columnToField.put(fcInfo.columnName, fcInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldColumnInfo {
        private boolean updatable;
        private boolean insertable;
        private String columnName;
        private String columnTableName;
        private Field field;
        private Class<?> fieldType;
        private EnumType enumType;
        private Map<Object, Object> enumConstants;

        public FieldColumnInfo(Field field) {
            this.field = field;
            this.fieldType = field.getType();
            if (this.fieldType == Date.class) {
                this.fieldType = Timestamp.class;
            } else if (this.fieldType == Integer.TYPE) {
                this.fieldType = Integer.class;
            } else if (this.fieldType == Long.TYPE) {
                this.fieldType = Long.class;
            }
        }

        <T extends Enum<?>> void setEnumConstants(EnumType type) {
            Enum[] enums;
            this.enumType = type;
            this.enumConstants = new HashMap<Object, Object>();
            for (Enum enumConst : enums = (Enum[])this.field.getType().getEnumConstants()) {
                Object key = type == EnumType.ORDINAL ? Integer.valueOf(enumConst.ordinal()) : enumConst.name();
                this.enumConstants.put(key, enumConst);
            }
        }

        public String toString() {
            return this.field.getName() + "->" + this.columnName;
        }
    }
}

