/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.Introspected;
import com.zaxxer.sansorm.internal.Introspector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrmBase {
    private static Map<String, String> csvCache = new ConcurrentHashMap<String, String>();

    protected OrmBase() {
    }

    protected static final void populateStatementParameters(PreparedStatement stmt, Object ... args) throws SQLException {
        ParameterMetaData parameterMetaData = stmt.getParameterMetaData();
        int paramCount = parameterMetaData.getParameterCount();
        if (paramCount > 0 && args.length < paramCount) {
            throw new RuntimeException("Too few parameters supplied for query");
        }
        for (int column = paramCount; column > 0; --column) {
            int parameterType = parameterMetaData.getParameterType(column);
            Object object = OrmBase.mapSqlType(args[column - 1], parameterType);
            stmt.setObject(column, object, parameterType);
        }
    }

    public static final <T> String getColumnsCsv(Class<T> clazz, String ... tablePrefix) {
        String cacheKey = tablePrefix == null || tablePrefix.length == 0 ? clazz.getName() : tablePrefix[0] + clazz.getName();
        String columnCsv = csvCache.get(cacheKey);
        if (columnCsv == null) {
            Introspected introspected = Introspector.getIntrospected(clazz);
            StringBuilder sb = new StringBuilder();
            String[] columnNames = introspected.getColumnNames();
            String[] columnTableNames = introspected.getColumnTableNames();
            for (int i = 0; i < columnNames.length; ++i) {
                String column = columnNames[i];
                String columnTableName = columnTableNames[i];
                if (columnTableName != null) {
                    sb.append(columnTableName).append('.');
                } else if (tablePrefix.length > 0) {
                    sb.append(tablePrefix[0]).append('.');
                }
                sb.append(column).append(',');
            }
            columnCsv = sb.deleteCharAt(sb.length() - 1).toString();
            csvCache.put(cacheKey, columnCsv);
        }
        return columnCsv;
    }

    public static final <T> String getColumnsCsvExclude(Class<T> clazz, String ... excludeColumns) {
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(excludeColumns));
        Introspected introspected = Introspector.getIntrospected(clazz);
        StringBuilder sb = new StringBuilder();
        String[] columnNames = introspected.getColumnNames();
        String[] columnTableNames = introspected.getColumnTableNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String column = columnNames[i];
            if (excludes.contains(column)) continue;
            String columnTableName = columnTableNames[i];
            if (columnTableName != null) {
                sb.append(columnTableName).append('.');
            }
            sb.append(column).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    protected static final Object mapSqlType(Object object, int sqlType) {
        switch (sqlType) {
            case 93: {
                if (!(object instanceof Date)) break;
                return new Timestamp(((Date)object).getTime());
            }
            case 3: {
                if (!(object instanceof BigInteger)) break;
                return new BigDecimal((BigInteger)object);
            }
            case 5: {
                if (!(object instanceof Boolean)) break;
                return (Boolean)object != false ? (short)1 : 0;
            }
        }
        return object;
    }
}

