/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.Introspected;
import com.zaxxer.sansorm.internal.Introspector;
import com.zaxxer.sansorm.internal.OrmBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmReader
extends OrmBase {
    private static final int CACHE_SIZE = Integer.getInteger("com.zaxxer.sansorm.statementCacheSize", 500);
    private static final Map<String, String> fromClauseStmtCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(CACHE_SIZE){
        private static final long serialVersionUID = 6259942586093454872L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > CACHE_SIZE;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> statementToList(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        List<T> list;
        try {
            OrmReader.populateStatementParameters(stmt, args);
            list = OrmReader.resultSetToList(stmt.executeQuery(), clazz);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return list;
    }

    public static <T> List<T> resultSetToList(ResultSet resultSet, Class<T> targetClass) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        if (!resultSet.next()) {
            resultSet.close();
            return list;
        }
        Introspected introspected = Introspector.getIntrospected(targetClass);
        boolean hasJoinColumns = introspected.hasSelfJoinColumn();
        HashMap<T, Object> deferredSelfJoinFkMap = hasJoinColumns ? new HashMap<T, Object>() : null;
        HashMap<Object, T> idToTargetMap = hasJoinColumns ? new HashMap<Object, T>() : null;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int column = columnCount; column > 0; --column) {
            columnNames[column - 1] = metaData.getColumnName(column).toLowerCase();
        }
        try {
            do {
                T target = targetClass.newInstance();
                list.add(target);
                for (int column = columnCount; column > 0; --column) {
                    Object columnValue = resultSet.getObject(column);
                    if (columnValue == null) continue;
                    String columnName = columnNames[column - 1];
                    if (hasJoinColumns && introspected.isSelfJoinColumn(columnName)) {
                        deferredSelfJoinFkMap.put(target, columnValue);
                        continue;
                    }
                    introspected.set(target, columnName, columnValue);
                }
                if (!hasJoinColumns) continue;
                idToTargetMap.put(introspected.getActualIds(target)[0], target);
            } while (resultSet.next());
            resultSet.close();
            if (hasJoinColumns) {
                String idColumn = introspected.getSelfJoinColumn();
                for (Map.Entry entry : deferredSelfJoinFkMap.entrySet()) {
                    Object value = idToTargetMap.get(entry.getValue());
                    if (value == null) continue;
                    introspected.set(entry.getKey(), idColumn, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static <T> T statementToObject(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        T target2;
        block8: {
            ResultSet resultSet;
            block6: {
                T t;
                block7: {
                    OrmReader.populateStatementParameters(stmt, args);
                    resultSet = null;
                    resultSet = stmt.executeQuery();
                    if (!resultSet.next()) break block6;
                    T target2 = clazz.newInstance();
                    t = OrmReader.resultSetToObject(resultSet, target2);
                    Object var7_8 = null;
                    if (resultSet == null) break block7;
                    resultSet.close();
                }
                stmt.close();
                return t;
            }
            try {
                target2 = null;
                Object var7_9 = null;
                if (resultSet == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    stmt.close();
                    throw throwable;
                }
            }
            resultSet.close();
        }
        stmt.close();
        return target2;
    }

    public static <T> T resultSetToObject(ResultSet resultSet, T target) throws SQLException {
        Set<String> ignoreNone = Collections.emptySet();
        return OrmReader.resultSetToObject(resultSet, target, ignoreNone);
    }

    public static <T> T resultSetToObject(ResultSet resultSet, T target, Set<String> ignoredColumns) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Introspected introspected = Introspector.getIntrospected(target.getClass());
        for (int column = metaData.getColumnCount(); column > 0; --column) {
            Object columnValue;
            String columnName = metaData.getColumnName(column).toLowerCase();
            if (ignoredColumns.contains(columnName) || (columnValue = resultSet.getObject(column)) == null) continue;
            introspected.set(target, columnName, columnValue);
        }
        return target;
    }

    public static <T> T objectById(Connection connection, Class<T> clazz, Object ... args) throws SQLException {
        Introspected introspected = Introspector.getIntrospected(clazz);
        StringBuilder where = new StringBuilder();
        for (String column : introspected.getIdColumnNames()) {
            where.append(column).append("=? AND ");
        }
        if (where.length() > 0) {
            where.setLength(where.length() - 5);
        }
        return OrmReader.objectFromClause(connection, clazz, where.toString(), args);
    }

    public static <T> List<T> listFromClause(Connection connection, Class<T> clazz, String clause, Object ... args) throws SQLException {
        String sql = OrmReader.generateSelectFromClause(clazz, clause);
        PreparedStatement stmt = connection.prepareStatement(sql);
        List<T> list = OrmReader.statementToList(stmt, clazz, args);
        stmt.close();
        return list;
    }

    public static <T> T objectFromClause(Connection connection, Class<T> clazz, String clause, Object ... args) throws SQLException {
        String sql = OrmReader.generateSelectFromClause(clazz, clause);
        PreparedStatement stmt = connection.prepareStatement(sql);
        return OrmReader.statementToObject(stmt, clazz, args);
    }

    public static <T> int countObjectsFromClause(Connection connection, Class<T> clazz, String clause, Object ... args) throws SQLException {
        Introspected introspected = Introspector.getIntrospected(clazz);
        String tableName = introspected.getTableName();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(");
        String countColumn = tableName + ".";
        String[] idColumnNames = introspected.getIdColumnNames();
        countColumn = idColumnNames.length > 0 ? countColumn + idColumnNames[0] : countColumn + introspected.getColumnNames()[0];
        sql.append(countColumn).append(") FROM ").append(tableName).append(' ').append(tableName);
        if (clause != null && !clause.isEmpty()) {
            if (!clause.toUpperCase().contains("WHERE") && !clause.toUpperCase().contains("JOIN")) {
                sql.append(" WHERE ");
            }
            sql.append(' ').append(clause);
        }
        return OrmReader.numberFromSql(connection, sql.toString(), args).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Number numberFromSql(Connection connection, String sql, Object ... args) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            block5: {
                Number number;
                OrmReader.populateStatementParameters(stmt, args);
                resultSet = stmt.executeQuery();
                try {
                    if (!resultSet.next()) break block5;
                    number = (Number)resultSet.getObject(1);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                Object var9_10 = null;
                if (stmt == null) return number;
                stmt.close();
                return number;
            }
            Number number = null;
            Object var7_8 = null;
            resultSet.close();
            Object var9_11 = null;
            if (stmt == null) return number;
            stmt.close();
            return number;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
    }

    private static <T> String generateSelectFromClause(Class<T> clazz, String clause) {
        String cacheKey = clazz.getName() + clause;
        String sql = fromClauseStmtCache.get(cacheKey);
        if (sql == null) {
            Introspected introspected = Introspector.getIntrospected(clazz);
            String tableName = introspected.getTableName();
            StringBuilder sqlSB = new StringBuilder();
            sqlSB.append("SELECT ").append(OrmReader.getColumnsCsv(clazz, tableName)).append(" FROM ").append(tableName).append(' ').append(tableName);
            if (clause != null && !clause.isEmpty()) {
                if (!clause.toUpperCase().contains("WHERE") && !clause.toUpperCase().contains("JOIN")) {
                    sqlSB.append(" WHERE ");
                }
                sqlSB.append(' ').append(clause);
            }
            sql = sqlSB.toString();
            fromClauseStmtCache.put(cacheKey, sql);
        }
        return sql;
    }
}

