/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseEventProcessor<T extends BasePosixProcess>
implements IEventProcessor<T> {
    protected static final int DEADPOOL_POLL_INTERVAL;
    protected static final int LINGER_ITERATIONS;
    protected Map<Integer, T> pidToProcessMap = new ConcurrentHashMap<Integer, T>();
    protected Map<Integer, T> fildesToProcessMap = new ConcurrentHashMap<Integer, T>();
    protected volatile boolean shutdown;
    private CyclicBarrier startBarrier;
    private AtomicBoolean isRunning = new AtomicBoolean();

    @Override
    public void run() {
        try {
            this.startBarrier.await();
            int idleCount = 0;
            while (!this.isRunning.compareAndSet(idleCount > LINGER_ITERATIONS && this.pidToProcessMap.isEmpty(), false)) {
                idleCount = !this.shutdown && this.process() ? 0 : idleCount + 1;
            }
        }
        catch (Exception e) {
            this.isRunning.set(false);
        }
    }

    @Override
    public CyclicBarrier getSpawnBarrier() {
        this.startBarrier = new CyclicBarrier(2);
        return this.startBarrier;
    }

    @Override
    public boolean checkAndSetRunning() {
        return this.isRunning.compareAndSet(false, true);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        Collection<T> processes = this.pidToProcessMap.values();
        IntByReference exitCode = new IntByReference();
        for (BasePosixProcess process : processes) {
            LibC.kill(process.getPid(), 15);
            process.onExit(0x7FFFFFFE);
            LibC.waitpid(process.getPid(), exitCode, 1);
        }
    }

    static {
        int lingerTimeMs = Math.max(1000, Integer.getInteger("com.zaxxer.nuprocess.lingerTimeMs", 2500));
        DEADPOOL_POLL_INTERVAL = Math.min(lingerTimeMs, Math.max(100, Integer.getInteger("com.zaxxer.nuprocess.deadPoolPollMs", 250)));
        LINGER_ITERATIONS = lingerTimeMs / DEADPOOL_POLL_INTERVAL;
    }
}

