/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.zaxxer.nuprocess.windows.NuKernel32;
import com.zaxxer.nuprocess.windows.WindowsProcess;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ProcessCompletions
implements Runnable {
    private static final int DEADPOOL_POLL_INTERVAL;
    private static final int LINGER_ITERATIONS;
    private static final int STDOUT = 0;
    private static final int STDERR = 1;
    private WinNT.HANDLE ioCompletionPort;
    private List<WindowsProcess> deadPool;
    private BlockingQueue<WindowsProcess> pendingPool;
    private BlockingQueue<WindowsProcess> wantsWrite;
    private Map<Long, WindowsProcess> completionKeyToProcessMap = new HashMap<Long, WindowsProcess>();
    private volatile CyclicBarrier startBarrier;
    private volatile boolean shutdown;
    private AtomicBoolean isRunning;
    private IntByReference numberOfBytes;
    private BaseTSD.ULONG_PTRByReference completionKey;
    private PointerByReference lpOverlapped;

    public ProcessCompletions() {
        this.wantsWrite = new ArrayBlockingQueue<WindowsProcess>(512);
        this.pendingPool = new LinkedBlockingQueue<WindowsProcess>();
        this.deadPool = new LinkedList<WindowsProcess>();
        this.isRunning = new AtomicBoolean();
        this.numberOfBytes = new IntByReference();
        this.completionKey = new BaseTSD.ULONG_PTRByReference();
        this.lpOverlapped = new PointerByReference();
        this.initCompletionPort();
    }

    @Override
    public void run() {
        try {
            this.startBarrier.await();
            int idleCount = 0;
            while (!this.isRunning.compareAndSet(idleCount > LINGER_ITERATIONS && this.deadPool.isEmpty() && this.completionKeyToProcessMap.isEmpty(), false)) {
                idleCount = !this.shutdown && this.process() ? 0 : idleCount + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        try {
            int status = NuKernel32.GetQueuedCompletionStatus(this.ioCompletionPort, this.numberOfBytes, this.completionKey, this.lpOverlapped, DEADPOOL_POLL_INTERVAL);
            if (status == 0 && this.lpOverlapped.getValue() == null) {
                this.checkWaitWrites();
                this.checkPendingPool();
                boolean bl = false;
                return bl;
            }
            long key = this.completionKey.getValue().longValue();
            if (key == 0L) {
                this.checkWaitWrites();
                this.checkPendingPool();
                boolean bl = true;
                return bl;
            }
            WindowsProcess process = this.completionKeyToProcessMap.get(key);
            if (process == null) {
                boolean bl = true;
                return bl;
            }
            int transferred = this.numberOfBytes.getValue();
            if (process.getStdoutPipe().ioCompletionKey == key) {
                if (transferred > 0) {
                    process.readStdout(transferred);
                    this.queueRead(process, process.getStdoutPipe(), 0);
                } else {
                    process.readStdout(-1);
                }
            } else if (process.getStdinPipe().ioCompletionKey == key) {
                if (process.writeStdin(transferred)) {
                    this.queueWrite(process);
                }
            } else if (process.getStderrPipe().ioCompletionKey == key) {
                if (transferred > 0) {
                    process.readStderr(transferred);
                    this.queueRead(process, process.getStderrPipe(), 1);
                } else {
                    process.readStderr(-1);
                }
            }
            if (process.isSoftExit()) {
                this.cleanupProcess(process);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.checkDeadPool();
        }
    }

    void shutdown() {
        this.shutdown = true;
        Collection<WindowsProcess> processes = this.completionKeyToProcessMap.values();
        for (WindowsProcess process : processes) {
            NuKernel32.TerminateProcess(process.getPid(), 0x7FFFFFFE);
            process.onExit(0x7FFFFFFE);
        }
    }

    CyclicBarrier getSpawnBarrier() {
        this.startBarrier = new CyclicBarrier(2);
        return this.startBarrier;
    }

    boolean checkAndSetRunning() {
        return this.isRunning.compareAndSet(false, true);
    }

    void wantWrite(WindowsProcess process) {
        try {
            this.wantsWrite.put(process);
            NuKernel32.PostQueuedCompletionStatus(this.ioCompletionPort, 0, new BaseTSD.ULONG_PTR(0L), null);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void registerProcess(WindowsProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            this.pendingPool.put(process);
            NuKernel32.PostQueuedCompletionStatus(this.ioCompletionPort, 0, new BaseTSD.ULONG_PTR(0L), null);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void queueWrite(WindowsProcess process) {
        if (this.shutdown) {
            return;
        }
        WindowsProcess.PipeBundle stdinPipe = process.getStdinPipe();
        if (!stdinPipe.registered) {
            WinNT.HANDLE completionPort = NuKernel32.CreateIoCompletionPort(stdinPipe.pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(stdinPipe.ioCompletionKey), WindowsProcess.PROCESSOR_THREADS);
            if (!this.ioCompletionPort.equals((Object)completionPort)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            this.completionKeyToProcessMap.put(stdinPipe.ioCompletionKey, process);
            stdinPipe.registered = true;
        }
        if (NuKernel32.WriteFile(stdinPipe.pipeHandle, stdinPipe.bufferPointer, 0, null, stdinPipe.overlapped) == 0 && Native.getLastError() != 997) {
            process.stdinClose();
        }
    }

    private void queueRead(WindowsProcess process, WindowsProcess.PipeBundle pipe, int stdX) {
        if (NuKernel32.ReadFile(pipe.pipeHandle, pipe.bufferPointer, 65536, null, pipe.overlapped) == 0) {
            int lastError = Native.getLastError();
            switch (lastError) {
                case 0: 
                case 997: {
                    break;
                }
                case 109: 
                case 233: {
                    if (stdX == 0) {
                        process.readStdout(-1);
                        break;
                    }
                    process.readStderr(-1);
                    break;
                }
                default: {
                    System.err.println("Some other error occurred reading the pipe: " + lastError);
                }
            }
        }
    }

    private void checkPendingPool() {
        WindowsProcess process;
        while ((process = (WindowsProcess)this.pendingPool.poll()) != null) {
            WinNT.HANDLE completionPort1 = NuKernel32.CreateIoCompletionPort(process.getStdoutPipe().pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(process.getStdoutPipe().ioCompletionKey), WindowsProcess.PROCESSOR_THREADS);
            if (!this.ioCompletionPort.equals((Object)completionPort1)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            WinNT.HANDLE completionPort2 = NuKernel32.CreateIoCompletionPort(process.getStderrPipe().pipeHandle, this.ioCompletionPort, new BaseTSD.ULONG_PTR(process.getStderrPipe().ioCompletionKey), WindowsProcess.PROCESSOR_THREADS);
            if (!this.ioCompletionPort.equals((Object)completionPort2)) {
                throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
            }
            this.completionKeyToProcessMap.put(process.getStdoutPipe().ioCompletionKey, process);
            this.completionKeyToProcessMap.put(process.getStderrPipe().ioCompletionKey, process);
            this.queueRead(process, process.getStdoutPipe(), 0);
            this.queueRead(process, process.getStderrPipe(), 1);
        }
    }

    private void checkWaitWrites() {
        WindowsProcess process;
        while ((process = (WindowsProcess)this.wantsWrite.poll()) != null) {
            this.queueWrite(process);
        }
    }

    private void checkDeadPool() {
        if (this.deadPool.isEmpty()) {
            return;
        }
        IntByReference exitCode = new IntByReference();
        Iterator<WindowsProcess> iterator = this.deadPool.iterator();
        while (iterator.hasNext()) {
            WindowsProcess process = iterator.next();
            if (!NuKernel32.GetExitCodeProcess(process.getPid(), exitCode) || exitCode.getValue() == 259) continue;
            iterator.remove();
            process.onExit(exitCode.getValue());
        }
    }

    private void cleanupProcess(WindowsProcess process) {
        this.completionKeyToProcessMap.remove(process.getStdinPipe().ioCompletionKey);
        this.completionKeyToProcessMap.remove(process.getStdoutPipe().ioCompletionKey);
        this.completionKeyToProcessMap.remove(process.getStderrPipe().ioCompletionKey);
        IntByReference exitCode = new IntByReference();
        if (NuKernel32.GetExitCodeProcess(process.getPid(), exitCode) && exitCode.getValue() != 259) {
            process.onExit(exitCode.getValue());
        } else {
            this.deadPool.add(process);
        }
    }

    private void initCompletionPort() {
        this.ioCompletionPort = NuKernel32.CreateIoCompletionPort(WinNT.INVALID_HANDLE_VALUE, null, new BaseTSD.ULONG_PTR(0L), WindowsProcess.PROCESSOR_THREADS);
        if (this.ioCompletionPort == null) {
            throw new RuntimeException("CreateIoCompletionPort() failed, error code: " + Native.getLastError());
        }
    }

    static {
        int lingerTimeMs = Math.max(1000, Integer.getInteger("com.zaxxer.nuprocess.lingerTimeMs", 2500));
        DEADPOOL_POLL_INTERVAL = Math.min(lingerTimeMs, Math.max(100, Integer.getInteger("com.zaxxer.nuprocess.deadPoolPollMs", 250)));
        LINGER_ITERATIONS = lingerTimeMs / DEADPOOL_POLL_INTERVAL;
    }
}

