/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.UnsafeHelper;
import com.zaxxer.nuprocess.windows.NuKernel32;
import com.zaxxer.nuprocess.windows.ProcessCompletions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class WindowsProcess
implements NuProcess {
    public static final int PROCESSOR_THREADS;
    private static final boolean IS_SOFTEXIT_DETECTION;
    private static final int BUFFER_SIZE = 65536;
    private static final ProcessCompletions[] processors;
    private static int processorRoundRobin;
    private static final AtomicInteger namedPipeCounter;
    private volatile ProcessCompletions myProcessor;
    private volatile NuProcessHandler processHandler;
    private AtomicInteger exitCode;
    private CountDownLatch exitPending;
    AtomicBoolean userWantsWrite;
    private volatile boolean writePending;
    private volatile PipeBundle stdinPipe;
    private volatile PipeBundle stdoutPipe;
    private volatile PipeBundle stderrPipe;
    private WinNT.HANDLE hStdinWidow;
    private WinNT.HANDLE hStdoutWidow;
    private WinNT.HANDLE hStderrWidow;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;
    private int remainingWrite;
    private int writeOffset;
    private volatile boolean inClosed;
    private volatile boolean outClosed;
    private volatile boolean errClosed;
    private WinBase.PROCESS_INFORMATION processInfo;

    public WindowsProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.outClosed = true;
        this.errClosed = true;
        this.inClosed = true;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void wantWrite() {
        if (this.hStdinWidow != null && !WinBase.INVALID_HANDLE_VALUE.getPointer().equals((Object)this.hStdinWidow.getPointer())) {
            this.userWantsWrite.set(true);
            this.myProcessor.wantWrite(this);
        }
    }

    @Override
    public synchronized void writeStdin(ByteBuffer buffer) {
        if (this.hStdinWidow != null && !WinBase.INVALID_HANDLE_VALUE.getPointer().equals((Object)this.hStdinWidow.getPointer())) {
            this.pendingWrites.add(buffer);
            if (!this.writePending) {
                this.myProcessor.wantWrite(this);
            }
        } else {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
    }

    @Override
    public void closeStdin() {
        this.stdinClose();
    }

    @Override
    public void destroy() {
        NuKernel32.TerminateProcess(this.processInfo.hProcess, Integer.MAX_VALUE);
    }

    @Override
    public boolean isRunning() {
        return this.exitPending.getCount() != 0L;
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NuProcess start(List<String> commands, String[] environment) {
        try {
            this.createPipes();
            char[] block = this.getEnvironment(environment);
            Memory env = new Memory((long)(block.length * 3));
            env.write(0L, block, 0, block.length);
            WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
            startupInfo.clear();
            startupInfo.cb = new WinDef.DWORD((long)startupInfo.size());
            startupInfo.hStdInput = this.hStdinWidow;
            startupInfo.hStdError = this.hStderrWidow;
            startupInfo.hStdOutput = this.hStdoutWidow;
            startupInfo.dwFlags = 256;
            this.processInfo = new WinBase.PROCESS_INFORMATION();
            WinDef.DWORD dwCreationFlags = new WinDef.DWORD(0x8000404L);
            if (!NuKernel32.CreateProcessW(null, this.getCommandLine(commands), null, null, true, dwCreationFlags, (Pointer)env, null, startupInfo, this.processInfo)) {
                int lastError = Native.getLastError();
                throw new RuntimeException("CreateProcessW() failed, error: " + lastError);
            }
            this.afterStart();
            this.registerProcess();
            this.callStart();
            NuKernel32.ResumeThread(this.processInfo.hThread);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.onExit(Integer.MIN_VALUE);
        }
        finally {
            NuKernel32.CloseHandle(this.hStdinWidow);
            NuKernel32.CloseHandle(this.hStdoutWidow);
            NuKernel32.CloseHandle(this.hStderrWidow);
        }
        return this;
    }

    WinNT.HANDLE getPid() {
        return this.processInfo.hProcess;
    }

    PipeBundle getStdinPipe() {
        return this.stdinPipe;
    }

    PipeBundle getStdoutPipe() {
        return this.stdoutPipe;
    }

    PipeBundle getStderrPipe() {
        return this.stderrPipe;
    }

    void readStdout(int transferred) {
        if (this.outClosed) {
            return;
        }
        try {
            if (transferred < 0) {
                this.outClosed = true;
                this.processHandler.onStdout(null);
                return;
            }
            if (transferred == 0) {
                return;
            }
            ByteBuffer buffer = this.stdoutPipe.buffer;
            buffer.position(0);
            buffer.limit(transferred);
            this.processHandler.onStdout(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void readStderr(int transferred) {
        if (this.errClosed) {
            return;
        }
        try {
            if (transferred < 0) {
                this.errClosed = true;
                this.processHandler.onStderr(null);
                return;
            }
            if (transferred == 0) {
                return;
            }
            ByteBuffer buffer = this.stderrPipe.buffer;
            buffer.position(0);
            buffer.limit(transferred);
            this.processHandler.onStderr(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean writeStdin(int transferred) {
        if (this.writePending && transferred == 0) {
            return false;
        }
        this.writeOffset += transferred;
        this.remainingWrite -= transferred;
        if (this.remainingWrite > 0) {
            NuKernel32.WriteFile(this.stdinPipe.pipeHandle, this.stdinPipe.bufferPointer.share((long)this.writeOffset), this.remainingWrite, null, this.stdinPipe.overlapped);
            this.writePending = true;
            return false;
        }
        this.writePending = false;
        this.stdinPipe.buffer.clear();
        this.remainingWrite = 0;
        this.writeOffset = 0;
        if (!this.pendingWrites.isEmpty()) {
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.stdinPipe.buffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
                this.remainingWrite = 65536;
            } else {
                this.remainingWrite = byteBuffer.remaining();
                this.stdinPipe.buffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            if (this.remainingWrite > 0) {
                return true;
            }
        }
        if (this.userWantsWrite.compareAndSet(true, false)) {
            try {
                ByteBuffer buffer = this.stdinPipe.buffer;
                buffer.clear();
                this.userWantsWrite.set(this.processHandler.onStdinReady(buffer));
                this.remainingWrite = buffer.remaining();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.exitPending.countDown();
            this.exitCode.set(statusCode);
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!this.inClosed) {
                NuKernel32.CloseHandle(this.stdinPipe.pipeHandle);
            }
            NuKernel32.CloseHandle(this.stdoutPipe.pipeHandle);
            NuKernel32.CloseHandle(this.stderrPipe.pipeHandle);
            NuKernel32.CloseHandle(this.processInfo.hThread);
            NuKernel32.CloseHandle(this.processInfo.hProcess);
            Native.free((long)Pointer.nativeValue((Pointer)this.stdoutPipe.bufferPointer));
            Native.free((long)Pointer.nativeValue((Pointer)this.stderrPipe.bufferPointer));
            Native.free((long)Pointer.nativeValue((Pointer)this.stdinPipe.bufferPointer));
            this.stderrPipe = null;
            this.stdoutPipe = null;
            this.stdinPipe = null;
            this.processHandler = null;
        }
    }

    boolean isSoftExit() {
        return this.outClosed && this.errClosed && IS_SOFTEXIT_DETECTION;
    }

    void stdinClose() {
        if (!this.inClosed) {
            NuKernel32.CloseHandle(this.stdinPipe.pipeHandle);
            this.inClosed = true;
        }
    }

    private void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPipes() {
        WinBase.SECURITY_ATTRIBUTES sattr = new WinBase.SECURITY_ATTRIBUTES();
        sattr.dwLength = new WinDef.DWORD((long)sattr.size());
        sattr.bInheritHandle = true;
        sattr.lpSecurityDescriptor = null;
        long ioCompletionKey = namedPipeCounter.getAndIncrement();
        WString pipeName = new WString("\\\\.\\pipe\\NuProcess" + ioCompletionKey);
        this.hStdoutWidow = NuKernel32.CreateNamedPipeW(pipeName, 2, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStdoutWidow);
        WinNT.HANDLE stdoutHandle = NuKernel32.CreateFile(pipeName, Integer.MIN_VALUE, 1, null, 3, 0x40000080, null);
        this.checkHandleValidity(stdoutHandle);
        this.stdoutPipe = new PipeBundle(stdoutHandle, ioCompletionKey);
        this.checkPipeConnected(NuKernel32.ConnectNamedPipe(this.hStdoutWidow, null));
        ioCompletionKey = namedPipeCounter.getAndIncrement();
        pipeName = new WString("\\\\.\\pipe\\NuProcess" + ioCompletionKey);
        this.hStderrWidow = NuKernel32.CreateNamedPipeW(pipeName, 2, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStderrWidow);
        WinNT.HANDLE stderrHandle = NuKernel32.CreateFile(pipeName, Integer.MIN_VALUE, 1, null, 3, 0x40000080, null);
        this.checkHandleValidity(stderrHandle);
        this.stderrPipe = new PipeBundle(stderrHandle, ioCompletionKey);
        this.checkPipeConnected(NuKernel32.ConnectNamedPipe(this.hStderrWidow, null));
        ioCompletionKey = namedPipeCounter.getAndIncrement();
        pipeName = new WString("\\\\.\\pipe\\NuProcess" + ioCompletionKey);
        this.hStdinWidow = NuKernel32.CreateNamedPipeW(pipeName, 1, 0, 1, 65536, 65536, 0, sattr);
        this.checkHandleValidity(this.hStdinWidow);
        WinNT.HANDLE stdinHandle = NuKernel32.CreateFile(pipeName, 0x40000000, 2, null, 3, 0x40000080, null);
        this.checkHandleValidity(stdinHandle);
        this.stdinPipe = new PipeBundle(stdinHandle, ioCompletionKey);
        this.checkPipeConnected(NuKernel32.ConnectNamedPipe(this.hStdinWidow, null));
    }

    private void afterStart() {
        this.pendingWrites = new ConcurrentLinkedQueue();
        this.outClosed = false;
        this.errClosed = false;
        this.inClosed = false;
        long peer = Native.malloc((long)65536L);
        this.stdoutPipe.buffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.stdoutPipe.bufferPointer = new Pointer(peer);
        peer = Native.malloc((long)65536L);
        this.stderrPipe.buffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.stderrPipe.bufferPointer = new Pointer(peer);
        peer = Native.malloc((long)65536L);
        this.stdinPipe.buffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.stdinPipe.bufferPointer = new Pointer(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProcess() {
        int mySlot = 0;
        ProcessCompletions[] processCompletionsArray = processors;
        synchronized (processors) {
            mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread((Runnable)this.myProcessor, "ProcessIoCompletion" + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    private char[] getCommandLine(List<String> commands) {
        StringBuilder sb = new StringBuilder();
        if (commands.get(0).contains(" ") && !commands.get(0).startsWith("\"") && !commands.get(0).endsWith("\"")) {
            commands.set(0, "\"" + commands.get(0).replaceAll("\\\"", "\\\"") + "\"");
        }
        for (String s : commands) {
            sb.append(s).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('\u0000');
        return sb.toString().toCharArray();
    }

    private char[] getEnvironment(String[] environment) {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        for (String entry : environment) {
            int ndx = entry.indexOf(61);
            if (ndx == -1) continue;
            env.put(entry.substring(0, ndx), ndx < entry.length() ? entry.substring(ndx + 1) : "");
        }
        return this.getEnvironmentBlock(env).toCharArray();
    }

    private String getEnvironmentBlock(Map<String, String> env) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(env.entrySet());
        Collections.sort(list, new EntryComparator());
        StringBuilder sb = new StringBuilder(32 * env.size());
        for (Map.Entry entry : list) {
            sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\u0000');
        }
        sb.append('\u0000').append('\u0000');
        return sb.toString();
    }

    private void checkHandleValidity(WinNT.HANDLE handle) {
        if (WinBase.INVALID_HANDLE_VALUE.getPointer().equals((Object)handle)) {
            throw new RuntimeException("Unable to create pipe, error " + Native.getLastError());
        }
    }

    private void checkPipeConnected(int status) {
        int lastError;
        if (status == 0 && (lastError = Native.getLastError()) != 535) {
            throw new RuntimeException("Unable to connect pipe, error: " + lastError);
        }
    }

    static {
        namedPipeCounter = new AtomicInteger(100);
        IS_SOFTEXIT_DETECTION = Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
        String threads = System.getProperty("com.zaxxer.nuprocess.threads", "auto");
        PROCESSOR_THREADS = "auto".equals(threads) ? Math.max(1, Runtime.getRuntime().availableProcessors() / 2) : ("cores".equals(threads) ? Runtime.getRuntime().availableProcessors() : Math.max(1, Integer.parseInt(threads)));
        processors = new ProcessCompletions[PROCESSOR_THREADS];
        for (int i = 0; i < PROCESSOR_THREADS; ++i) {
            WindowsProcess.processors[i] = new ProcessCompletions();
        }
        if (Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true")).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < processors.length; ++i) {
                        if (processors[i] == null) continue;
                        processors[i].shutdown();
                    }
                }
            }));
        }
    }

    static final class PipeBundle {
        final NuKernel32.OVERLAPPED overlapped;
        final long ioCompletionKey;
        final WinNT.HANDLE pipeHandle;
        ByteBuffer buffer;
        Pointer bufferPointer;
        boolean registered;

        PipeBundle(WinNT.HANDLE pipeHandle, long ioCompletionKey) {
            this.pipeHandle = pipeHandle;
            this.ioCompletionKey = ioCompletionKey;
            this.overlapped = new NuKernel32.OVERLAPPED();
        }
    }

    private static final class EntryComparator
    implements Comparator<Map.Entry<String, String>> {
        static NameComparator nameComparator = new NameComparator();

        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            return nameComparator.compare(e1.getKey(), e2.getKey());
        }
    }

    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int len1 = s1.length();
            int len2 = s2.length();
            for (int i = 0; i < Math.min(len1, len2); ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }
}

