/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.UnsafeHelper;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BasePosixProcess
implements NuProcess {
    protected static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    protected static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
    private static final boolean LINUX_USE_VFORK = Boolean.parseBoolean(System.getProperty("com.zaxxer.nuprocess.linuxUseVfork", "true"));
    private static final boolean IS_SOFTEXIT_DETECTION = Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
    protected static IEventProcessor<? extends BasePosixProcess>[] processors;
    protected static int processorRoundRobin;
    protected IEventProcessor<? super BasePosixProcess> myProcessor;
    protected volatile NuProcessHandler processHandler;
    protected volatile int pid;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected AtomicBoolean userWantsWrite;
    protected ByteBuffer outBuffer;
    protected ByteBuffer inBuffer;
    protected Pointer outBufferPointer;
    protected Pointer inBufferPointer;
    protected AtomicInteger stdin;
    protected AtomicInteger stdout;
    protected AtomicInteger stderr;
    protected volatile int stdinWidow;
    protected volatile int stdoutWidow;
    protected volatile int stderrWidow;
    protected boolean outClosed;
    protected boolean errClosed;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;
    private int remainingWrite;
    private int writeOffset;
    private Pointer posix_spawn_file_actions;

    protected BasePosixProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.stdin = new AtomicInteger(-1);
        this.stdout = new AtomicInteger(-1);
        this.stderr = new AtomicInteger(-1);
        this.outClosed = true;
        this.errClosed = true;
    }

    @Override
    public boolean isRunning() {
        return this.exitPending.getCount() != 0L;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void destroy() {
        if (this.exitPending.getCount() != 0L) {
            LibC.kill(this.pid, 15);
            IntByReference exit = new IntByReference();
            LibC.waitpid(this.pid, exit, 0);
            this.exitCode.set(exit.getValue());
        }
    }

    @Override
    public void wantWrite() {
        int fd = this.stdin.get();
        if (fd == -1) {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
        this.userWantsWrite.set(true);
        this.myProcessor.queueWrite(this);
    }

    @Override
    public void closeStdin() {
        int fd = this.stdin.getAndSet(-1);
        if (fd != -1) {
            if (this.myProcessor != null) {
                this.myProcessor.closeStdin(this);
            }
            LibC.close(fd);
        }
    }

    @Override
    public void writeStdin(ByteBuffer buffer) {
        int fd = this.stdin.get();
        if (fd == -1) {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
        this.pendingWrites.add(buffer);
        this.myProcessor.queueWrite(this);
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NuProcess start(List<String> command, String[] environment) {
        String[] commands = command.toArray(new String[0]);
        Pointer posix_spawn_file_actions = this.createPipes();
        Memory posix_spawnattr = null;
        if (IS_LINUX) {
            long peer = Native.malloc((long)340L);
            posix_spawnattr = new Pointer(peer);
        } else {
            posix_spawnattr = new Memory((long)Pointer.SIZE);
        }
        try {
            int rc = LibC.posix_spawnattr_init((Pointer)posix_spawnattr);
            this.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
            short flags = 0;
            if (IS_LINUX && LINUX_USE_VFORK) {
                flags = 64;
            } else if (IS_MAC) {
                flags = 16512;
            }
            LibC.posix_spawnattr_setflags((Pointer)posix_spawnattr, flags);
            IntByReference restrict_pid = new IntByReference();
            rc = LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, (Pointer)posix_spawnattr, new StringArray(commands), (Pointer)new StringArray(environment));
            this.pid = restrict_pid.getValue();
            if (IS_LINUX) {
                IntByReference exit = new IntByReference();
                LibC.waitpid(this.pid, exit, 1);
                rc = (exit.getValue() & 0xFF00) >> 8;
                if (rc == 127) {
                    this.onExit(Integer.MIN_VALUE);
                    NuProcess nuProcess = null;
                    return nuProcess;
                }
            }
            this.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.registerProcess();
            this.callStart();
            if (IS_MAC) {
                LibC.kill(this.pid, 19);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.err);
            this.onExit(Integer.MIN_VALUE);
            NuProcess nuProcess = null;
            return nuProcess;
        }
        finally {
            LibC.posix_spawnattr_destroy((Pointer)posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            LibC.close(this.stdinWidow);
            LibC.close(this.stdoutWidow);
            LibC.close(this.stderrWidow);
            if (IS_LINUX) {
                Native.free((long)Pointer.nativeValue((Pointer)posix_spawn_file_actions));
                Native.free((long)Pointer.nativeValue((Pointer)posix_spawnattr));
            }
        }
        return this;
    }

    public int getPid() {
        return this.pid;
    }

    public AtomicInteger getStdin() {
        return this.stdin;
    }

    public AtomicInteger getStdout() {
        return this.stdout;
    }

    public AtomicInteger getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return IS_SOFTEXIT_DETECTION && this.outClosed && this.errClosed;
    }

    public void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin();
            this.close(this.stdout);
            this.close(this.stderr);
            this.exitCode.set(statusCode);
            this.exitPending.countDown();
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception exception) {
        }
        finally {
            Native.free((long)Pointer.nativeValue((Pointer)this.outBufferPointer));
            Native.free((long)Pointer.nativeValue((Pointer)this.inBufferPointer));
            this.processHandler = null;
        }
    }

    public void readStdout(int availability) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.processHandler.onStdout(null);
                return;
            }
            if (availability == 0) {
                return;
            }
            int read = LibC.read(this.stdout.get(), this.outBufferPointer, Math.min(availability, 65536));
            if (read == -1) {
                this.outClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.position(0);
            this.outBuffer.limit(read);
            this.processHandler.onStdout(this.outBuffer);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void readStderr(int availability) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.processHandler.onStderr(null);
                return;
            }
            int read = LibC.read(this.stderr.get(), this.outBufferPointer, Math.min(availability, 65536));
            if (read == -1) {
                this.errClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.position(0);
            this.outBuffer.limit(read);
            this.processHandler.onStderr(this.outBuffer);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean writeStdin(int availability) {
        int fd = this.stdin.get();
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.remainingWrite > 0) {
            int wrote = 0;
            do {
                if ((wrote = LibC.write(fd, this.inBufferPointer.share((long)this.writeOffset), Math.min(this.remainingWrite, availability))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                System.err.println("EOF?");
                this.close(this.stdin);
                return false;
            } while (wrote < 0);
            this.remainingWrite -= wrote;
            this.writeOffset += wrote;
            if (this.remainingWrite > 0) {
                return true;
            }
            this.inBuffer.clear();
            this.remainingWrite = 0;
            this.writeOffset = 0;
        }
        if (!this.pendingWrites.isEmpty()) {
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
                this.remainingWrite = 65536;
            } else {
                this.remainingWrite = byteBuffer.remaining();
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            if (this.remainingWrite > 0) {
                return this.writeStdin(availability);
            }
        }
        if (!this.userWantsWrite.get()) {
            return false;
        }
        try {
            this.inBuffer.clear();
            boolean wantMore = this.processHandler.onStdinReady(this.inBuffer);
            this.userWantsWrite.set(wantMore);
            this.remainingWrite = this.inBuffer.remaining();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void afterStart() {
        this.outClosed = false;
        this.errClosed = false;
        this.pendingWrites = new ConcurrentLinkedQueue();
        long peer = Native.malloc((long)65536L);
        this.outBuffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.outBufferPointer = new Pointer(peer);
        peer = Native.malloc((long)65536L);
        this.inBuffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.inBufferPointer = new Pointer(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProcess() {
        int mySlot = 0;
        IEventProcessor<? extends BasePosixProcess>[] iEventProcessorArray = processors;
        synchronized (processors) {
            mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread(this.myProcessor, (IS_LINUX ? "ProcessEpoll" : "ProcessKqueue") + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    private void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void close(AtomicInteger stdX) {
        int fd = stdX.getAndSet(-1);
        if (fd != -1) {
            LibC.close(fd);
        }
    }

    private Pointer createPipes() {
        int rc = 0;
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        this.posix_spawn_file_actions = null;
        if (IS_LINUX) {
            long peer = Native.malloc((long)80L);
            this.posix_spawn_file_actions = new Pointer(peer);
        } else {
            this.posix_spawn_file_actions = new Memory((long)Pointer.SIZE);
        }
        try {
            rc = LibC.pipe(in);
            this.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            this.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            this.checkReturnCode(rc, "Create stderr pipe() failed");
            rc = LibC.posix_spawn_file_actions_init(this.posix_spawn_file_actions);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(this.posix_spawn_file_actions, in[0], 0);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(this.posix_spawn_file_actions, in[1]);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdin.set(in[1]);
            this.stdinWidow = in[0];
            rc = LibC.posix_spawn_file_actions_adddup2(this.posix_spawn_file_actions, out[1], 1);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(this.posix_spawn_file_actions, out[0]);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdout.set(out[0]);
            this.stdoutWidow = out[1];
            rc = LibC.posix_spawn_file_actions_adddup2(this.posix_spawn_file_actions, err[1], 2);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(this.posix_spawn_file_actions, err[0]);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stderr.set(err[0]);
            this.stderrWidow = err[1];
            if (IS_LINUX || IS_MAC) {
                rc = LibC.fcntl(in[1], 4, LibC.fcntl(in[1], 3) | LibC.O_NONBLOCK);
                this.checkReturnCode(rc, "fnctl on stdin handle failed");
                rc = LibC.fcntl(out[0], 4, LibC.fcntl(out[0], 3) | LibC.O_NONBLOCK);
                this.checkReturnCode(rc, "fnctl on stdout handle failed");
                rc = LibC.fcntl(err[0], 4, LibC.fcntl(err[0], 3) | LibC.O_NONBLOCK);
                this.checkReturnCode(rc, "fnctl on stderr handle failed");
            }
            return this.posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
            LibC.posix_spawn_file_actions_destroy(this.posix_spawn_file_actions);
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    private void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            LibC.close(fildes);
        }
    }

    private void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    static {
        int numThreads = 1;
        String threads = System.getProperty("com.zaxxer.nuprocess.threads", "auto");
        numThreads = "auto".equals(threads) ? Math.max(1, Runtime.getRuntime().availableProcessors() / 2) : ("cores".equals(threads) ? Runtime.getRuntime().availableProcessors() : Math.max(1, Integer.parseInt(threads)));
        processors = new IEventProcessor[numThreads];
        if (Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true")).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < processors.length; ++i) {
                        if (processors[i] == null) continue;
                        processors[i].shutdown();
                    }
                }
            }));
        }
    }
}

