/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.zaxxer.nuprocess.internal.HexDumpElf;

public class EpollEvent {
    private Pointer pointer;
    private static final int MALLOC_SIZE = 4 + Pointer.SIZE + 4 + 4 + 8;
    private static final int EPOLL_DATA_START = Pointer.SIZE;
    public static final int EPOLL_CTL_ADD = 1;
    public static final int EPOLL_CTL_DEL = 2;
    public static final int EPOLL_CTL_MOD = 3;
    public static final int EPOLLIN = 1;
    public static final int EPOLLOUT = 4;
    public static final int EPOLLERR = 8;
    public static final int EPOLLHUP = 16;
    public static final int EPOLLRDHUP = 8192;
    public static final int EPOLLONESHOT = 0x40000000;
    public static final int EPOLLET = Integer.MIN_VALUE;

    EpollEvent() {
        long memory = Native.malloc((long)MALLOC_SIZE);
        this.pointer = new Pointer(memory);
        this.pointer.clear((long)MALLOC_SIZE);
    }

    void free() {
        Native.free((long)Pointer.nativeValue((Pointer)this.pointer));
    }

    void clear() {
        this.pointer.clear((long)MALLOC_SIZE);
    }

    Pointer getPointer() {
        return this.pointer;
    }

    int getEvents() {
        return this.pointer.getInt(0L);
    }

    void setEvents(int events) {
        this.pointer.setInt(0L, events);
    }

    int getFd() {
        return this.pointer.getInt((long)(EPOLL_DATA_START + 4));
    }

    void setFd(int fd) {
        this.pointer.setInt((long)(EPOLL_DATA_START + 4), fd);
    }

    int getUnused() {
        return this.pointer.getInt(8L);
    }

    void setUnused(int unused) {
        this.pointer.setInt(8L, unused);
    }

    public String toString() {
        byte[] byteArray = this.pointer.getByteArray(0L, MALLOC_SIZE);
        return HexDumpElf.dump(0, byteArray, 0, byteArray.length);
    }
}

