/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.linux.EpollEvent;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.LinuxProcess;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class ProcessEpoll
extends BaseEventProcessor<LinuxProcess> {
    private static final int EVENT_POOL_SIZE = 32;
    private int epoll;
    private EpollEvent triggeredEvent;
    private List<LinuxProcess> deadPool;
    private static BlockingQueue<EpollEvent> eventPool;
    AtomicInteger count = new AtomicInteger();

    ProcessEpoll() {
        this.epoll = LibEpoll.epoll_create(1024);
        if (this.epoll < 0) {
            throw new RuntimeException("Unable to create kqueue: " + Native.getLastError());
        }
        this.triggeredEvent = new EpollEvent();
        this.deadPool = new LinkedList<LinuxProcess>();
        eventPool = new ArrayBlockingQueue<EpollEvent>(32);
        for (int i = 0; i < 32; ++i) {
            eventPool.add(new EpollEvent());
        }
    }

    @Override
    public void registerProcess(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        this.pidToProcessMap.put(process.getPid(), process);
        this.fildesToProcessMap.put(process.getStdin().get(), process);
        this.fildesToProcessMap.put(process.getStdout().get(), process);
        this.fildesToProcessMap.put(process.getStderr().get(), process);
        try {
            EpollEvent event = eventPool.take();
            event.setEvents(1);
            event.setFd(process.getStdout().get());
            int rc = LibEpoll.epoll_ctl(this.epoll, 1, process.getStdout().get(), event.getPointer());
            if (rc == -1) {
                rc = Native.getLastError();
                eventPool.put(event);
                throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
            }
            eventPool.put(event);
            event = eventPool.take();
            event.setEvents(1);
            event.setFd(process.getStderr().get());
            rc = LibEpoll.epoll_ctl(this.epoll, 1, process.getStderr().get(), event.getPointer());
            if (rc == -1) {
                rc = Native.getLastError();
                eventPool.put(event);
                throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
            }
            eventPool.put(event);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void queueWrite(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            int stdin = process.getStdin().get();
            EpollEvent event = eventPool.take();
            event.setEvents(1073750036);
            event.setFd(stdin);
            int rc = LibEpoll.epoll_ctl(this.epoll, 3, stdin, event.getPointer());
            if (rc == -1) {
                rc = LibEpoll.epoll_ctl(this.epoll, 2, stdin, event.getPointer());
                rc = LibEpoll.epoll_ctl(this.epoll, 1, stdin, event.getPointer());
            }
            eventPool.put(event);
            if (rc == -1) {
                throw new RuntimeException("Unable to register new event to epoll queue");
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void closeStdin(LinuxProcess process) {
        int stdin = process.getStdin().get();
        this.fildesToProcessMap.remove(stdin);
        LibEpoll.epoll_ctl(this.epoll, 2, stdin, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() {
        try {
            int nev = LibEpoll.epoll_wait(this.epoll, this.triggeredEvent.getPointer(), 1, DEADPOOL_POLL_INTERVAL);
            if (nev == -1) {
                throw new RuntimeException("Error waiting for epoll");
            }
            if (nev == 0) {
                boolean bl = false;
                return bl;
            }
            EpollEvent epEvent = this.triggeredEvent;
            int ident = epEvent.getFd();
            int events = epEvent.getEvents();
            LinuxProcess linuxProcess = (LinuxProcess)this.fildesToProcessMap.get(ident);
            if (linuxProcess == null) {
                boolean bl = true;
                return bl;
            }
            if ((events & 1) != 0) {
                if (ident == linuxProcess.getStdout().get()) {
                    linuxProcess.readStdout(65536);
                } else {
                    linuxProcess.readStderr(65536);
                }
            } else if ((events & 4) != 0 && linuxProcess.getStdin().get() != -1 && linuxProcess.writeStdin(65536)) {
                epEvent.setEvents(1073750036);
                LibEpoll.epoll_ctl(this.epoll, 3, ident, epEvent.getPointer());
            }
            if ((events & 0x10) != 0 || (events & 0x2000) != 0 || (events & 8) != 0) {
                LibEpoll.epoll_ctl(this.epoll, 2, ident, null);
                if (ident == linuxProcess.getStdout().get()) {
                    linuxProcess.readStdout(-1);
                } else if (ident == linuxProcess.getStderr().get()) {
                    linuxProcess.readStderr(-1);
                } else if (ident == linuxProcess.getStdin().get()) {
                    linuxProcess.closeStdin();
                }
            }
            if (linuxProcess.isSoftExit()) {
                this.cleanupProcess(linuxProcess);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.triggeredEvent.clear();
            this.checkDeadPool();
        }
    }

    private void cleanupProcess(LinuxProcess linuxProcess) {
        this.pidToProcessMap.remove(linuxProcess.getPid());
        this.fildesToProcessMap.remove(linuxProcess.getStdin().get());
        this.fildesToProcessMap.remove(linuxProcess.getStdout().get());
        this.fildesToProcessMap.remove(linuxProcess.getStderr().get());
        IntByReference exitCode = new IntByReference();
        int rc = LibC.waitpid(linuxProcess.getPid(), exitCode, 1);
        if (rc == -1) {
            if (Native.getLastError() == 10) {
                rc = (exitCode.getValue() & 0xFF00) >> 8;
                if (rc == 127) {
                    linuxProcess.onExit(Integer.MIN_VALUE);
                    return;
                }
                linuxProcess.onExit(rc);
            } else {
                this.deadPool.add(linuxProcess);
            }
        } else {
            rc = (exitCode.getValue() & 0xFF00) >> 8;
            if (rc == 127) {
                linuxProcess.onExit(Integer.MIN_VALUE);
                return;
            }
            linuxProcess.onExit(rc);
        }
    }

    private void checkDeadPool() {
        if (this.deadPool.isEmpty()) {
            return;
        }
        IntByReference exitCode = new IntByReference();
        Iterator<LinuxProcess> iterator = this.deadPool.iterator();
        while (iterator.hasNext()) {
            LinuxProcess process = iterator.next();
            int rc = LibC.waitpid(process.getPid(), exitCode, 1);
            if (rc == -1) {
                if (Native.getLastError() != 10) continue;
                iterator.remove();
                process.onExit(Integer.MAX_VALUE);
                continue;
            }
            rc = (exitCode.getValue() & 0xFF00) >> 8;
            if (rc == 127) {
                rc = Integer.MIN_VALUE;
            }
            iterator.remove();
            process.onExit(rc);
        }
    }
}

