/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

public final class Kevent {
    private Pointer pointer;
    public static final int EV_ADD = 1;
    public static final int EV_DELETE = 2;
    public static final int EV_ENABLE = 4;
    public static final int EV_DISABLE = 8;
    public static final int EV_RECEIPT = 64;
    public static final int EV_ONESHOT = 16;
    public static final int EV_CLEAR = 32;
    public static final int EV_DISPATCH = 128;
    public static final int EV_SYSFLAGS = 61440;
    public static final int EV_FLAG0 = 4096;
    public static final int EV_FLAG1 = 8192;
    public static final int EV_EOF = 32768;
    public static final int EV_ERROR = 16384;
    public static final int EVFILT_READ = -1;
    public static final int EVFILT_WRITE = -2;
    public static final int EVFILT_AIO = -3;
    public static final int EVFILT_VNODE = -4;
    public static final int EVFILT_PROC = -5;
    public static final int EVFILT_SIGNAL = -6;
    public static final int EVFILT_TIMER = -7;
    public static final int EVFILT_MACHPORT = -8;
    public static final int EVFILT_FS = -9;
    public static final int EVFILT_USER = -10;
    public static final int EVFILT_VM = -12;
    public static final int NOTE_EXIT = Integer.MIN_VALUE;
    public static final int NOTE_REAP = 0x10000000;
    public static final int NOTE_EXITSTATUS = 0x4000000;

    public Kevent() {
        long memory = Native.malloc((long)32L);
        this.pointer = new Pointer(memory);
    }

    void free() {
        Native.free((long)Pointer.nativeValue((Pointer)this.pointer));
    }

    void clear() {
        this.pointer.clear(32L);
    }

    Pointer getPointer() {
        return this.pointer;
    }

    long getIdent() {
        return this.pointer.getLong(0L);
    }

    void setIdent(long ident) {
        this.pointer.setLong(0L, ident);
    }

    short getFilter() {
        return this.pointer.getShort((long)NativeLong.SIZE);
    }

    void setFilter(short filter) {
        this.pointer.setShort((long)NativeLong.SIZE, filter);
    }

    short getFlags() {
        return this.pointer.getShort((long)(NativeLong.SIZE + 2));
    }

    void setFlags(short flags) {
        this.pointer.setShort((long)(NativeLong.SIZE + 2), flags);
    }

    int getFilterFlags() {
        return this.pointer.getInt((long)(NativeLong.SIZE + 2 + 2));
    }

    void setFilterFlags(int filterFlags) {
        this.pointer.setInt((long)(NativeLong.SIZE + 2 + 2), filterFlags);
    }

    long getData() {
        return this.pointer.getLong((long)(NativeLong.SIZE + 2 + 2 + 4));
    }

    void setData(long data) {
        this.pointer.setLong((long)(NativeLong.SIZE + 2 + 2 + 4), data);
    }

    Pointer getUserData() {
        return this.pointer.getPointer((long)(NativeLong.SIZE + 2 + 2 + 4 + NativeLong.SIZE));
    }

    void setUserData(Pointer ptr) {
        this.pointer.setPointer((long)(NativeLong.SIZE + 2 + 2 + 4 + NativeLong.SIZE), ptr);
    }

    protected static Kevent EV_SET(Kevent kev, long ident, int filter, int flags, int fflags, long data, Pointer udata) {
        kev.setIdent(ident);
        kev.setFilter((short)filter);
        kev.setFlags((short)flags);
        kev.setFilterFlags(fflags);
        kev.setData(data);
        kev.setUserData(udata);
        return kev;
    }
}

