/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.osx.Kevent;
import com.zaxxer.nuprocess.osx.LibKevent;
import com.zaxxer.nuprocess.osx.OsxProcess;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

final class ProcessKqueue
extends BaseEventProcessor<OsxProcess> {
    private static final int KEVENT_POOL_SIZE = 16;
    private static final LibKevent.TimeSpec timeSpec;
    private static final int JAVA_PID;
    private volatile int kqueue = LibKevent.kqueue();
    private Kevent triggeredEvent;
    private BlockingQueue<Kevent> keventPool;
    private BlockingQueue<OsxProcess> closeQueue;
    private BlockingQueue<OsxProcess> wantsWrite;

    ProcessKqueue() {
        if (this.kqueue < 0) {
            throw new RuntimeException("Unable to create kqueue");
        }
        this.closeQueue = new ArrayBlockingQueue<OsxProcess>(512);
        this.wantsWrite = new ArrayBlockingQueue<OsxProcess>(512);
        this.triggeredEvent = new Kevent();
        this.keventPool = new ArrayBlockingQueue<Kevent>(16);
        for (int i = 0; i < 16; ++i) {
            this.keventPool.add(new Kevent());
        }
    }

    @Override
    public void registerProcess(OsxProcess process) {
        if (this.shutdown) {
            return;
        }
        int pid = process.getPid();
        Pointer pidPointer = new Pointer((long)pid);
        this.pidToProcessMap.put(pid, process);
        this.queueEvent(process.getPid(), -5, 17, -1811939328, pidPointer);
        this.queueEvent(31, -6, 1, 0, pidPointer);
        this.queueEvent(process.getStdout().get(), -1, 17, 0, pidPointer);
        this.queueEvent(process.getStderr().get(), -1, 17, 0, pidPointer);
    }

    @Override
    public void queueWrite(OsxProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            this.wantsWrite.put(process);
        }
        catch (InterruptedException e) {
            return;
        }
        LibC.kill(JAVA_PID, 31);
    }

    @Override
    public void closeStdin(OsxProcess process) {
        this.closeQueue.add(process);
    }

    @Override
    public boolean process() {
        int nev = LibKevent.kevent(this.kqueue, null, 0, this.triggeredEvent.getPointer(), 1, timeSpec);
        if (nev == -1) {
            throw new RuntimeException("Error waiting for kevent");
        }
        if (nev == 0) {
            return false;
        }
        Kevent kevent = this.triggeredEvent;
        int ident = (int)kevent.getIdent();
        short filter = kevent.getFilter();
        int udata = (int)Pointer.nativeValue((Pointer)kevent.getUserData());
        OsxProcess osxProcess = (OsxProcess)this.pidToProcessMap.get(udata);
        if (osxProcess == null && (osxProcess = (OsxProcess)this.pidToProcessMap.get(ident)) == null) {
            return true;
        }
        if (filter == -1) {
            int available = (int)kevent.getData();
            if (ident == osxProcess.getStdout().get()) {
                osxProcess.readStdout(available);
                if ((kevent.getFlags() & 0x8000) != 0) {
                    osxProcess.readStdout(-1);
                } else {
                    this.queueEvent(ident, -1, 17, 0, kevent.getUserData());
                }
            } else if (ident == osxProcess.getStderr().get()) {
                osxProcess.readStderr(available);
                if ((kevent.getFlags() & 0x8000) != 0) {
                    osxProcess.readStderr(-1);
                } else {
                    this.queueEvent(osxProcess.getStderr().get(), -1, 17, 0, kevent.getUserData());
                }
            }
        } else if (filter == -2 && ident == osxProcess.getStdin().get()) {
            int available = (int)kevent.getData();
            if (available == 0 || osxProcess.writeStdin(4096)) {
                this.queueEvent(osxProcess.getStdin().get(), -2, 17, 0, new Pointer((long)osxProcess.getPid()));
            }
        } else if ((kevent.getFilterFlags() & Integer.MIN_VALUE) != 0) {
            this.cleanupProcess(osxProcess);
            int status = (int)kevent.getData();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    osxProcess.onExit(Integer.MIN_VALUE);
                } else {
                    osxProcess.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                osxProcess.onExit(LibC.WTERMSIG(status));
            } else {
                osxProcess.onExit(status);
            }
        } else if (filter == -6) {
            this.checkStdinCloses();
            this.checkWaitWrites();
        }
        kevent.clear();
        return true;
    }

    private void queueEvent(int handle, int filter, int flags, int fflags, Pointer udata) {
        try {
            Kevent kevent = this.keventPool.take();
            Kevent.EV_SET(kevent, handle, filter, flags, fflags, 0L, udata);
            LibKevent.kevent(this.kqueue, kevent.getPointer(), 1, null, 0, null);
            this.keventPool.put(kevent);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void checkStdinCloses() {
        OsxProcess process;
        if (this.closeQueue.isEmpty()) {
            return;
        }
        while ((process = (OsxProcess)this.closeQueue.poll()) != null) {
            process.stdinClose();
        }
    }

    private void checkWaitWrites() {
        OsxProcess process;
        if (this.wantsWrite.isEmpty()) {
            return;
        }
        while ((process = (OsxProcess)this.wantsWrite.poll()) != null) {
            int fd = process.getStdin().get();
            if (fd == -1) continue;
            this.queueEvent(process.getStdin().get(), -2, 17, 0, new Pointer((long)process.getPid()));
        }
    }

    private void cleanupProcess(OsxProcess osxProcess) {
        LibC.waitpid(osxProcess.getPid(), new IntByReference(), 1);
        this.pidToProcessMap.remove(osxProcess.getPid());
    }

    static {
        JAVA_PID = LibC.getpid();
        timeSpec = new LibKevent.TimeSpec();
        ProcessKqueue.timeSpec.tv_sec = 0L;
        ProcessKqueue.timeSpec.tv_nsec = TimeUnit.MILLISECONDS.toNanos(DEADPOOL_POLL_INTERVAL);
    }
}

