/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseEventProcessor<T extends BasePosixProcess>
implements IEventProcessor<T> {
    protected static final int LINGER_TIME_MS = Math.max(1000, Integer.getInteger("com.zaxxer.nuprocess.lingerTimeMs", 2500));
    protected static final int DEADPOOL_POLL_INTERVAL = Math.min(LINGER_TIME_MS, Math.max(100, Integer.getInteger("com.zaxxer.nuprocess.deadPoolPollMs", 250)));
    protected static final int LINGER_ITERATIONS = LINGER_TIME_MS / DEADPOOL_POLL_INTERVAL;
    private final int lingerIterations;
    protected Map<Integer, T> pidToProcessMap;
    protected Map<Integer, T> fildesToProcessMap;
    protected volatile boolean shutdown;
    private CyclicBarrier startBarrier;
    private AtomicBoolean isRunning;

    public BaseEventProcessor() {
        this(LINGER_ITERATIONS);
    }

    public BaseEventProcessor(int lingerIterations) {
        this.lingerIterations = lingerIterations;
        this.pidToProcessMap = new ConcurrentHashMap<Integer, T>();
        this.fildesToProcessMap = new ConcurrentHashMap<Integer, T>();
        this.isRunning = new AtomicBoolean();
    }

    @Override
    public void run() {
        try {
            this.startBarrier.await();
            int idleCount = 0;
            while (!this.isRunning.compareAndSet(idleCount > this.lingerIterations && this.pidToProcessMap.isEmpty(), false)) {
                idleCount = !this.shutdown && this.process() ? 0 : idleCount + 1;
            }
        }
        catch (Exception e) {
            this.isRunning.set(false);
        }
    }

    @Override
    public CyclicBarrier getSpawnBarrier() {
        this.startBarrier = new CyclicBarrier(2);
        return this.startBarrier;
    }

    @Override
    public boolean checkAndSetRunning() {
        return this.isRunning.compareAndSet(false, true);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        Collection<T> processes = this.pidToProcessMap.values();
        IntByReference exitCode = new IntByReference();
        for (BasePosixProcess process : processes) {
            LibC.kill(process.getPid(), 15);
            process.onExit(0x7FFFFFFE);
            LibC.waitpid(process.getPid(), exitCode, 1);
        }
    }
}

