/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.LinuxLibC;
import com.zaxxer.nuprocess.internal.UnsafeHelper;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BasePosixProcess
implements NuProcess {
    protected static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    protected static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
    private static final boolean LINUX_USE_VFORK = Boolean.parseBoolean(System.getProperty("com.zaxxer.nuprocess.linuxUseVfork", "true"));
    private static final boolean IS_SOFTEXIT_DETECTION = Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
    protected static final IEventProcessor<? extends BasePosixProcess>[] processors;
    protected static int processorRoundRobin;
    private static ExecutorService linuxCwdExecutorService;
    protected IEventProcessor<? super BasePosixProcess> myProcessor;
    protected volatile NuProcessHandler processHandler;
    protected volatile int pid;
    protected volatile boolean isRunning;
    public final AtomicBoolean cleanlyExitedBeforeProcess;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected AtomicBoolean userWantsWrite;
    protected ByteBuffer outBuffer;
    protected ByteBuffer errBuffer;
    protected ByteBuffer inBuffer;
    protected Pointer outBufferPointer;
    protected Pointer errBufferPointer;
    protected Pointer inBufferPointer;
    protected AtomicInteger stdin;
    protected AtomicInteger stdout;
    protected AtomicInteger stderr;
    protected volatile int stdinWidow;
    protected volatile int stdoutWidow;
    protected volatile int stderrWidow;
    protected boolean outClosed;
    protected boolean errClosed;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;
    private int remainingWrite;
    private int writeOffset;
    private Pointer posix_spawn_file_actions;

    protected BasePosixProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.cleanlyExitedBeforeProcess = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.stdin = new AtomicInteger(-1);
        this.stdout = new AtomicInteger(-1);
        this.stderr = new AtomicInteger(-1);
        this.outClosed = true;
        this.errClosed = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void destroy(boolean force) {
        if (this.isRunning) {
            BasePosixProcess.checkReturnCode(LibC.kill(this.pid, force ? 9 : 15), "Sending signal failed");
        }
    }

    @Override
    public void wantWrite() {
        int fd = this.stdin.get();
        if (fd == -1) {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
        this.userWantsWrite.set(true);
        this.myProcessor.queueWrite(this);
    }

    @Override
    public void closeStdin() {
        int fd = this.stdin.getAndSet(-1);
        if (fd != -1) {
            if (this.myProcessor != null) {
                this.myProcessor.closeStdin(this);
            }
            LibC.close(fd);
        }
    }

    @Override
    public void writeStdin(ByteBuffer buffer) {
        int fd = this.stdin.get();
        if (fd == -1) {
            throw new IllegalStateException("closeStdin() method has already been called.");
        }
        this.pendingWrites.add(buffer);
        this.myProcessor.queueWrite(this);
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        Memory posix_spawnattr;
        this.callPreStart();
        String[] commands = command.toArray(new String[command.size()]);
        Pointer posix_spawn_file_actions = this.createPipes();
        if (IS_LINUX) {
            long peer = Native.malloc((long)340L);
            posix_spawnattr = new Pointer(peer);
        } else {
            posix_spawnattr = new Memory((long)Pointer.SIZE);
        }
        try {
            int rc = LibC.posix_spawnattr_init((Pointer)posix_spawnattr);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
            short flags = 0;
            if (IS_LINUX && LINUX_USE_VFORK) {
                flags = 64;
            } else if (IS_MAC) {
                flags = 16512;
            }
            LibC.posix_spawnattr_setflags((Pointer)posix_spawnattr, flags);
            IntByReference restrict_pid = new IntByReference();
            StringArray commandsArray = new StringArray(commands);
            StringArray environmentArray = new StringArray(environment);
            if (cwd != null) {
                if (IS_MAC) {
                    rc = this.spawnOsxWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, (Pointer)posix_spawnattr, commandsArray, (Pointer)environmentArray, cwd);
                } else {
                    if (!IS_LINUX) throw new RuntimeException("Platform does not support per-thread cwd override");
                    rc = this.spawnLinuxWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, (Pointer)posix_spawnattr, commandsArray, (Pointer)environmentArray, cwd);
                }
            } else {
                rc = LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, (Pointer)posix_spawnattr, commandsArray, (Pointer)environmentArray);
            }
            this.pid = restrict_pid.getValue();
            this.initializeBuffers();
            if (IS_LINUX) {
                boolean cleanExit;
                IntByReference ret = new IntByReference();
                int waitpidRc = LibC.waitpid(this.pid, ret, 1);
                int status = ret.getValue();
                boolean bl = cleanExit = waitpidRc == this.pid && LibC.WIFEXITED(status) && LibC.WEXITSTATUS(status) == 0;
                if (cleanExit) {
                    this.cleanlyExitedBeforeProcess.set(true);
                } else if (waitpidRc != 0) {
                    if (LibC.WIFEXITED(status)) {
                        if ((status = LibC.WEXITSTATUS(status)) == 127) {
                            this.onExit(Integer.MIN_VALUE);
                        } else {
                            this.onExit(status);
                        }
                    } else if (LibC.WIFSIGNALED(status)) {
                        this.onExit(LibC.WTERMSIG(status));
                    }
                    NuProcess nuProcess = null;
                    return nuProcess;
                }
            }
            BasePosixProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.registerProcess();
            this.callStart();
            if (!IS_MAC) return this;
            LibC.kill(this.pid, 19);
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.err);
            this.onExit(Integer.MIN_VALUE);
            NuProcess nuProcess = null;
            return nuProcess;
        }
        finally {
            LibC.posix_spawnattr_destroy((Pointer)posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            LibC.close(this.stdinWidow);
            LibC.close(this.stdoutWidow);
            LibC.close(this.stderrWidow);
            if (IS_LINUX) {
                Native.free((long)Pointer.nativeValue((Pointer)posix_spawn_file_actions));
                Native.free((long)Pointer.nativeValue((Pointer)posix_spawnattr));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spawnOsxWithCwd(IntByReference restrict_pid, String restrict_path, Pointer file_actions, Pointer restrict_attrp, StringArray argv, Pointer envp, Path cwd) {
        int n;
        int cwdBufSize = 1024;
        long peer = Native.malloc((long)cwdBufSize);
        Pointer oldCwd = new Pointer(peer);
        LibC.getcwd(oldCwd, cwdBufSize);
        String newCwd = cwd.toAbsolutePath().toString();
        int rc = LibC.SYSCALL.syscall(348, newCwd);
        BasePosixProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to set current directory");
        try {
            n = LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
        }
        catch (Throwable throwable) {
            rc = LibC.SYSCALL.syscall(348, oldCwd);
            Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
            BasePosixProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
            throw throwable;
        }
        rc = LibC.SYSCALL.syscall(348, oldCwd);
        Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
        BasePosixProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
        return n;
    }

    private int spawnLinuxWithCwd(final IntByReference restrict_pid, final String restrict_path, final Pointer file_actions, final Pointer restrict_attrp, final StringArray argv, final Pointer envp, final Path cwd) {
        Future<Integer> setCwdThenSpawnFuture = linuxCwdExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                int rc = LibC.chdir(cwd.toAbsolutePath().toString());
                BasePosixProcess.checkReturnCode(rc, "chdir() failed");
                return LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
            }
        });
        try {
            return setCwdThenSpawnFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPid() {
        return this.pid;
    }

    public AtomicInteger getStdin() {
        return this.stdin;
    }

    public AtomicInteger getStdout() {
        return this.stdout;
    }

    public AtomicInteger getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return IS_SOFTEXIT_DETECTION && this.outClosed && this.errClosed;
    }

    public void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin();
            this.close(this.stdout);
            this.close(this.stderr);
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.outBuffer != null && !this.outClosed) {
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
            }
            if (this.errBuffer != null && !this.errClosed) {
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
            }
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.exitPending.countDown();
            Native.free((long)Pointer.nativeValue((Pointer)this.outBufferPointer));
            Native.free((long)Pointer.nativeValue((Pointer)this.errBufferPointer));
            Native.free((long)Pointer.nativeValue((Pointer)this.inBufferPointer));
            this.processHandler = null;
        }
    }

    public void readStdout(int availability) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
                return;
            }
            int read = LibC.read(this.stdout.get(), this.outBufferPointer.share((long)this.outBuffer.position()), Math.min(availability, this.outBuffer.remaining()));
            if (read == -1) {
                this.outClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.limit(this.outBuffer.position() + read);
            this.outBuffer.position(0);
            this.processHandler.onStdout(this.outBuffer, false);
            this.outBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.outBuffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    public void readStderr(int availability) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
                return;
            }
            int read = LibC.read(this.stderr.get(), this.errBufferPointer.share((long)this.errBuffer.position()), Math.min(availability, this.errBuffer.remaining()));
            if (read == -1) {
                this.errClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.errBuffer.limit(this.errBuffer.position() + read);
            this.errBuffer.position(0);
            this.processHandler.onStderr(this.errBuffer, false);
            this.errBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.errBuffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    public boolean writeStdin(int availability) {
        int fd = this.stdin.get();
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.remainingWrite > 0) {
            int wrote;
            do {
                if ((wrote = LibC.write(fd, this.inBufferPointer.share((long)this.writeOffset), Math.min(this.remainingWrite, availability))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                this.close(this.stdin);
                return false;
            } while (wrote < 0);
            this.remainingWrite -= wrote;
            this.writeOffset += wrote;
            if (this.remainingWrite > 0) {
                return true;
            }
            this.inBuffer.clear();
            this.remainingWrite = 0;
            this.writeOffset = 0;
        }
        if (!this.pendingWrites.isEmpty()) {
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
                this.remainingWrite = 65536;
            } else {
                this.remainingWrite = byteBuffer.remaining();
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            if (this.remainingWrite > 0) {
                return this.writeStdin(availability);
            }
        }
        if (!this.userWantsWrite.get()) {
            return false;
        }
        try {
            this.inBuffer.clear();
            boolean wantMore = this.processHandler.onStdinReady(this.inBuffer);
            this.userWantsWrite.set(wantMore);
            this.remainingWrite = this.inBuffer.remaining();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void afterStart() {
        this.isRunning = true;
    }

    private void initializeBuffers() {
        this.outClosed = false;
        this.errClosed = false;
        this.pendingWrites = new ConcurrentLinkedQueue();
        long peer = Native.malloc((long)65536L);
        this.outBuffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.outBufferPointer = new Pointer(peer);
        peer = Native.malloc((long)65536L);
        this.errBuffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.errBufferPointer = new Pointer(peer);
        peer = Native.malloc((long)65536L);
        this.inBuffer = UnsafeHelper.wrapNativeMemory(peer, 65536);
        this.inBufferPointer = new Pointer(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProcess() {
        IEventProcessor<? extends BasePosixProcess>[] iEventProcessorArray = processors;
        synchronized (processors) {
            int mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread(this.myProcessor, (IS_LINUX ? "ProcessEpoll" : "ProcessKqueue") + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    private void callPreStart() {
        try {
            this.processHandler.onPreStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void close(AtomicInteger stdX) {
        int fd = stdX.getAndSet(-1);
        if (fd != -1) {
            LibC.close(fd);
        }
    }

    private Pointer createPipes() {
        Memory posix_spawn_file_actions;
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        if (IS_LINUX) {
            long peer = Native.malloc((long)80L);
            posix_spawn_file_actions = new Pointer(peer);
        } else {
            posix_spawn_file_actions = new Memory((long)Pointer.SIZE);
        }
        try {
            int rc = LibC.pipe(in);
            BasePosixProcess.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            BasePosixProcess.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            BasePosixProcess.checkReturnCode(rc, "Create stderr pipe() failed");
            rc = LibC.posix_spawn_file_actions_init((Pointer)posix_spawn_file_actions);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2((Pointer)posix_spawn_file_actions, in[0], 0);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose((Pointer)posix_spawn_file_actions, in[1]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdin.set(in[1]);
            this.stdinWidow = in[0];
            rc = LibC.posix_spawn_file_actions_adddup2((Pointer)posix_spawn_file_actions, out[1], 1);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose((Pointer)posix_spawn_file_actions, out[0]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdout.set(out[0]);
            this.stdoutWidow = out[1];
            rc = LibC.posix_spawn_file_actions_adddup2((Pointer)posix_spawn_file_actions, err[1], 2);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose((Pointer)posix_spawn_file_actions, err[0]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stderr.set(err[0]);
            this.stderrWidow = err[1];
            if (IS_LINUX || IS_MAC) {
                rc = LibC.fcntl(in[1], 4, LibC.fcntl(in[1], 3) | LibC.O_NONBLOCK);
                BasePosixProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
                rc = LibC.fcntl(out[0], 4, LibC.fcntl(out[0], 3) | LibC.O_NONBLOCK);
                BasePosixProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
                rc = LibC.fcntl(err[0], 4, LibC.fcntl(err[0], 3) | LibC.O_NONBLOCK);
                BasePosixProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
            }
            return posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
            LibC.posix_spawn_file_actions_destroy((Pointer)posix_spawn_file_actions);
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    private void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            LibC.close(fildes);
        }
    }

    private static void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    static {
        String threads = System.getProperty("com.zaxxer.nuprocess.threads", "auto");
        int numThreads = "auto".equals(threads) ? Math.max(1, Runtime.getRuntime().availableProcessors() / 2) : ("cores".equals(threads) ? Runtime.getRuntime().availableProcessors() : Math.max(1, Integer.parseInt(threads)));
        processors = new IEventProcessor[numThreads];
        if (Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true")).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (IEventProcessor<? extends BasePosixProcess> processor : processors) {
                        if (processor == null) continue;
                        processor.shutdown();
                    }
                }
            }));
        }
        if (IS_LINUX) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, BaseEventProcessor.LINGER_TIME_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LinuxCwdThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
            executor.allowCoreThreadTimeOut(true);
            linuxCwdExecutorService = executor;
        }
    }

    public static class LinuxCwdThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(final Runnable r) {
            Runnable unshareCwdThenSpawn = new Runnable(){

                @Override
                public void run() {
                    int rc = LinuxLibC.unshare(512);
                    BasePosixProcess.checkReturnCode(rc, "unshare(CLONE_FS) failed");
                    r.run();
                }
            };
            Thread newThread = Executors.defaultThreadFactory().newThread(unshareCwdThenSpawn);
            newThread.setName(String.format("NuProcessLinuxCwdChangeable-%d", this.threadCount.incrementAndGet()));
            return newThread;
        }
    }
}

