/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.osx.LibKevent;
import com.zaxxer.nuprocess.osx.OsxProcess;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

final class ProcessKqueue
extends BaseEventProcessor<OsxProcess> {
    private static final int LINGER_ITERATIONS = 0;
    private static final int NUM_KEVENTS = 64;
    private static final int JAVA_PID = LibC.getpid();
    private volatile int kqueue = LibKevent.kqueue();
    private LibKevent.Kevent[] processEvents;
    private BlockingQueue<OsxProcess> closeQueue;
    private BlockingQueue<OsxProcess> wantsWrite;

    ProcessKqueue() {
        super(0);
        if (this.kqueue < 0) {
            throw new RuntimeException("Unable to create kqueue");
        }
        this.closeQueue = new ArrayBlockingQueue<OsxProcess>(512);
        this.wantsWrite = new ArrayBlockingQueue<OsxProcess>(512);
        this.processEvents = (LibKevent.Kevent[])new LibKevent.Kevent().toArray(64);
        this.processEvents[0].EV_SET(31L, -6, 65, 0, 0L, Pointer.NULL);
        this.registerEvents(this.processEvents, 1);
    }

    @Override
    public void registerProcess(OsxProcess process) {
        if (this.shutdown) {
            return;
        }
        int pid = process.getPid();
        Pointer pidPointer = Pointer.createConstant((int)pid);
        this.pidToProcessMap.put(pid, process);
        LibKevent.Kevent[] events = (LibKevent.Kevent[])new LibKevent.Kevent().toArray(4);
        events[0].EV_SET(pid, -5, 81, -1811939328, 0L, pidPointer);
        events[1].EV_SET(process.getStdout().get(), -1, 65, 0, 0L, pidPointer);
        events[2].EV_SET(process.getStderr().get(), -1, 65, 0, 0L, pidPointer);
        events[3].EV_SET(process.getStdin().get(), -2, 73, 0, 0L, pidPointer);
        this.registerEvents(events, 4);
    }

    private void registerEvents(LibKevent.Kevent[] keventArray, int numEvents) {
        for (int i = 0; i < numEvents; ++i) {
            keventArray[i].write();
        }
        int ret = LibKevent.kevent(this.kqueue, keventArray[0].getPointer(), numEvents, keventArray[0].getPointer(), numEvents, null);
        for (int i = 0; i < numEvents; ++i) {
            keventArray[i].read();
        }
        if (ret != numEvents) {
            throw new RuntimeException(String.format("Error %d registering events (ret=%d)", Native.getLastError(), ret));
        }
        StringBuilder err = new StringBuilder();
        for (int i = 0; i < ret; ++i) {
            int error = keventArray[i].data.intValue();
            if (error == 0) continue;
            err.append(String.format("kevent %d: error %d\n", i, error));
        }
        if (err.length() > 0) {
            throw new RuntimeException(err.toString());
        }
    }

    @Override
    public void queueWrite(OsxProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            this.wantsWrite.put(process);
        }
        catch (InterruptedException e) {
            return;
        }
        LibC.kill(JAVA_PID, 31);
    }

    @Override
    public void closeStdin(OsxProcess process) {
        this.closeQueue.add(process);
    }

    @Override
    public boolean process() {
        LibKevent.TimeSpec timeout;
        if (this.pidToProcessMap.isEmpty()) {
            timeout = new LibKevent.TimeSpec();
            timeout.tv_sec = LINGER_TIME_MS / 1000;
            timeout.tv_nsec = TimeUnit.MILLISECONDS.toNanos(LINGER_TIME_MS % 1000);
        } else {
            timeout = null;
        }
        int nev = LibKevent.kevent(this.kqueue, null, 0, this.processEvents[0].getPointer(), this.processEvents.length, timeout);
        if (nev == -1) {
            throw new RuntimeException("Error waiting for kevent");
        }
        if (nev == 0) {
            return false;
        }
        for (int i = 0; i < nev; ++i) {
            this.processEvents[i].read();
            this.processEvent(this.processEvents[i]);
        }
        return true;
    }

    private void processEvent(LibKevent.Kevent kevent) {
        int ident = kevent.ident.intValue();
        short filter = kevent.filter;
        int udata = (int)(0xFFFFFFFFFFFFFFFFL & Pointer.nativeValue((Pointer)kevent.udata));
        if (filter == -6) {
            this.checkStdinCloses();
            this.checkWaitWrites();
            return;
        }
        OsxProcess osxProcess = (OsxProcess)this.pidToProcessMap.get(udata);
        if (osxProcess == null && (osxProcess = (OsxProcess)this.pidToProcessMap.get(ident)) == null) {
            return;
        }
        if (filter == -1) {
            int available = kevent.data.intValue();
            if (ident == osxProcess.getStdout().get()) {
                osxProcess.readStdout(available);
                if ((kevent.flags & 0x8000) != 0) {
                    osxProcess.readStdout(-1);
                }
            } else if (ident == osxProcess.getStderr().get()) {
                osxProcess.readStderr(available);
                if ((kevent.flags & 0x8000) != 0) {
                    osxProcess.readStderr(-1);
                }
            }
        } else if (filter == -2 && ident == osxProcess.getStdin().get()) {
            int available = kevent.data.intValue();
            boolean userWantsMore = available > 0 ? osxProcess.writeStdin(available) : true;
            if (!userWantsMore) {
                LibKevent.Kevent[] events = (LibKevent.Kevent[])new LibKevent.Kevent().toArray(1);
                events[0].EV_SET(osxProcess.getStdin().get(), -2, 72, 0, 0L, Pointer.createConstant((int)osxProcess.getPid()));
                this.registerEvents(events, 1);
            }
        } else if ((kevent.fflags & Integer.MIN_VALUE) != 0) {
            this.cleanupProcess(osxProcess);
            int status = kevent.data.intValue();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    osxProcess.onExit(Integer.MIN_VALUE);
                } else {
                    osxProcess.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                osxProcess.onExit(LibC.WTERMSIG(status));
            } else {
                osxProcess.onExit(status);
            }
        }
    }

    private void checkStdinCloses() {
        ArrayList processes = new ArrayList();
        this.closeQueue.drainTo(processes);
        for (OsxProcess process : processes) {
            process.stdinClose();
        }
    }

    private void checkWaitWrites() {
        ArrayList processes = new ArrayList();
        this.wantsWrite.drainTo(processes, 64);
        if (!processes.isEmpty()) {
            LibKevent.Kevent[] kevents = (LibKevent.Kevent[])new LibKevent.Kevent().toArray(processes.size());
            for (int i = 0; i < processes.size(); ++i) {
                OsxProcess process = (OsxProcess)processes.get(i);
                kevents[i].EV_SET(process.getStdin().get(), -2, 68, 0, 0L, Pointer.createConstant((int)process.getPid()));
            }
            this.registerEvents(kevents, processes.size());
        }
    }

    private void cleanupProcess(OsxProcess osxProcess) {
        LibC.waitpid(osxProcess.getPid(), new IntByReference(), 1);
        this.pidToProcessMap.remove(osxProcess.getPid());
    }
}

