/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.linux.EpollEvent;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.LinuxProcess;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class ProcessEpoll
extends BaseEventProcessor<LinuxProcess> {
    private static final int EVENT_POOL_SIZE = 32;
    private int epoll;
    private EpollEvent triggeredEvent;
    private List<LinuxProcess> deadPool;
    private static BlockingQueue<EpollEvent> eventPool;
    AtomicInteger count = new AtomicInteger();

    ProcessEpoll() {
        this.epoll = LibEpoll.epoll_create(1024);
        if (this.epoll < 0) {
            throw new RuntimeException("Unable to create kqueue: " + Native.getLastError());
        }
        this.triggeredEvent = new EpollEvent();
        this.deadPool = new LinkedList<LinuxProcess>();
        eventPool = new ArrayBlockingQueue<EpollEvent>(32);
        for (int i = 0; i < 32; ++i) {
            eventPool.add(new EpollEvent());
        }
    }

    @Override
    public void registerProcess(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        int stdoutFd = process.getStdout().get();
        int stderrFd = process.getStderr().get();
        this.pidToProcessMap.put(process.getPid(), process);
        this.fildesToProcessMap.put(process.getStdin().get(), process);
        this.fildesToProcessMap.put(stdoutFd, process);
        this.fildesToProcessMap.put(stderrFd, process);
        try {
            EpollEvent event = eventPool.take();
            event.events = 1;
            event.data.fd = stdoutFd;
            int rc = LibEpoll.epoll_ctl(this.epoll, 1, stdoutFd, event);
            if (rc == -1) {
                rc = Native.getLastError();
                eventPool.put(event);
                throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
            }
            eventPool.put(event);
            event = eventPool.take();
            event.events = 1;
            event.data.fd = stderrFd;
            rc = LibEpoll.epoll_ctl(this.epoll, 1, stderrFd, event);
            if (rc == -1) {
                rc = Native.getLastError();
                eventPool.put(event);
                throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
            }
            eventPool.put(event);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void queueWrite(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            int stdin = process.getStdin().get();
            if (stdin == -1) {
                return;
            }
            EpollEvent event = eventPool.take();
            event.events = 1073750036;
            event.data.fd = stdin;
            int rc = LibEpoll.epoll_ctl(this.epoll, 3, stdin, event);
            if (rc == -1) {
                rc = LibEpoll.epoll_ctl(this.epoll, 2, stdin, event);
                rc = LibEpoll.epoll_ctl(this.epoll, 1, stdin, event);
            }
            eventPool.put(event);
            if (rc == -1) {
                throw new RuntimeException("Unable to register new event to epoll queue");
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void closeStdin(LinuxProcess process) {
        int stdin = process.getStdin().get();
        if (stdin != -1) {
            this.fildesToProcessMap.remove(stdin);
            LibEpoll.epoll_ctl(this.epoll, 2, stdin, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() {
        try {
            int nev = LibEpoll.epoll_wait(this.epoll, this.triggeredEvent, 1, DEADPOOL_POLL_INTERVAL);
            if (nev == -1) {
                throw new RuntimeException("Error waiting for epoll");
            }
            if (nev == 0) {
                boolean bl = false;
                return bl;
            }
            EpollEvent epEvent = this.triggeredEvent;
            int ident = epEvent.data.fd;
            int events = epEvent.events;
            LinuxProcess linuxProcess = (LinuxProcess)this.fildesToProcessMap.get(ident);
            if (linuxProcess == null) {
                boolean bl = true;
                return bl;
            }
            if ((events & 1) != 0) {
                if (ident == linuxProcess.getStdout().get()) {
                    linuxProcess.readStdout(65536);
                } else {
                    linuxProcess.readStderr(65536);
                }
            } else if ((events & 4) != 0 && linuxProcess.getStdin().get() != -1 && linuxProcess.writeStdin(65536)) {
                epEvent.events = 1073750036;
                LibEpoll.epoll_ctl(this.epoll, 3, ident, epEvent);
            }
            if ((events & 0x10) != 0 || (events & 0x2000) != 0 || (events & 8) != 0) {
                LibEpoll.epoll_ctl(this.epoll, 2, ident, null);
                if (ident == linuxProcess.getStdout().get()) {
                    linuxProcess.readStdout(-1);
                } else if (ident == linuxProcess.getStderr().get()) {
                    linuxProcess.readStderr(-1);
                } else if (ident == linuxProcess.getStdin().get()) {
                    linuxProcess.closeStdin(true);
                }
            }
            if (linuxProcess.isSoftExit()) {
                this.cleanupProcess(linuxProcess);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.triggeredEvent.clear();
            this.checkDeadPool();
        }
    }

    private void cleanupProcess(LinuxProcess linuxProcess) {
        this.pidToProcessMap.remove(linuxProcess.getPid());
        this.fildesToProcessMap.remove(linuxProcess.getStdin().get());
        this.fildesToProcessMap.remove(linuxProcess.getStdout().get());
        this.fildesToProcessMap.remove(linuxProcess.getStderr().get());
        if (linuxProcess.cleanlyExitedBeforeProcess.get()) {
            linuxProcess.onExit(0);
            return;
        }
        IntByReference ret = new IntByReference();
        int rc = LibC.waitpid(linuxProcess.getPid(), ret, 1);
        if (rc == 0) {
            this.deadPool.add(linuxProcess);
        } else if (rc < 0) {
            linuxProcess.onExit(Native.getLastError() == 10 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        } else {
            int status = ret.getValue();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    linuxProcess.onExit(Integer.MIN_VALUE);
                } else {
                    linuxProcess.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                linuxProcess.onExit(LibC.WTERMSIG(status));
            } else {
                linuxProcess.onExit(Integer.MIN_VALUE);
            }
        }
    }

    private void checkDeadPool() {
        if (this.deadPool.isEmpty()) {
            return;
        }
        IntByReference ret = new IntByReference();
        Iterator<LinuxProcess> iterator = this.deadPool.iterator();
        while (iterator.hasNext()) {
            LinuxProcess process = iterator.next();
            int rc = LibC.waitpid(process.getPid(), ret, 1);
            if (rc == 0) continue;
            iterator.remove();
            if (rc < 0) {
                process.onExit(Native.getLastError() == 10 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                continue;
            }
            int status = ret.getValue();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    process.onExit(Integer.MIN_VALUE);
                    continue;
                }
                process.onExit(status);
                continue;
            }
            if (LibC.WIFSIGNALED(status)) {
                process.onExit(LibC.WTERMSIG(status));
                continue;
            }
            process.onExit(Integer.MIN_VALUE);
        }
    }
}

