/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.osx.ProcessKqueue;
import java.nio.file.Path;

public class OsxProcess
extends BasePosixProcess {
    public OsxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    void stdinClose() {
        int fd = this.stdin.getAndSet(-1);
        if (fd != -1) {
            LibC.close(fd);
        }
    }

    @Override
    protected short getSpawnFlags() {
        return 16512;
    }

    @Override
    protected Pointer createPosixSpawnFileActions() {
        return new Memory((long)Pointer.SIZE);
    }

    @Override
    protected Pointer createPosixSpawnAttributes() {
        return new Memory((long)Pointer.SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int spawnWithCwd(IntByReference restrict_pid, String restrict_path, Pointer file_actions, Pointer restrict_attrp, StringArray argv, Pointer envp, Path cwd) {
        int n;
        int cwdBufSize = 1024;
        long peer = Native.malloc((long)cwdBufSize);
        Pointer oldCwd = new Pointer(peer);
        LibC.getcwd(oldCwd, cwdBufSize);
        String newCwd = cwd.toAbsolutePath().toString();
        int rc = LibC.SYSCALL.syscall(348, newCwd);
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to set current directory");
        try {
            n = LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
        }
        catch (Throwable throwable) {
            rc = LibC.SYSCALL.syscall(348, oldCwd);
            Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
            OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
            throw throwable;
        }
        rc = LibC.SYSCALL.syscall(348, oldCwd);
        Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
        return n;
    }

    @Override
    protected void singleProcessContinue() {
        LibC.kill(this.pid, 19);
    }

    static {
        for (int i = 0; i < processors.length; ++i) {
            OsxProcess.processors[i] = new ProcessKqueue();
        }
        LibC.signal(31, LibC.SIG_IGN);
    }
}

