/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.linux.EpollEvent;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.LinuxProcess;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class ProcessEpoll
extends BaseEventProcessor<LinuxProcess> {
    private static final int EVENT_POOL_SIZE = 64;
    private static final BlockingQueue<EpollEvent> eventPool = new ArrayBlockingQueue<EpollEvent>(64);
    private int epoll;
    private EpollEvent triggeredEvent;
    private List<LinuxProcess> deadPool;
    AtomicInteger count = new AtomicInteger();

    ProcessEpoll() {
        this.epoll = LibEpoll.epoll_create(1024);
        if (this.epoll < 0) {
            throw new RuntimeException("Unable to create kqueue: " + Native.getLastError());
        }
        this.triggeredEvent = new EpollEvent();
        this.deadPool = new LinkedList<LinuxProcess>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProcess(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        Integer stdinFd = null;
        Integer stdoutFd = null;
        Integer stderrFd = null;
        try {
            stdinFd = process.getStdin().acquire();
            stdoutFd = process.getStdout().acquire();
            stderrFd = process.getStderr().acquire();
            this.pidToProcessMap.put(process.getPid(), process);
            this.fildesToProcessMap.put(stdinFd, process);
            this.fildesToProcessMap.put(stdoutFd, process);
            this.fildesToProcessMap.put(stderrFd, process);
            try {
                EpollEvent event = eventPool.take();
                event.events = 1;
                event.data.fd = stdoutFd;
                int rc = LibEpoll.epoll_ctl(this.epoll, 1, stdoutFd, event);
                if (rc == -1) {
                    rc = Native.getLastError();
                    eventPool.put(event);
                    throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
                }
                eventPool.put(event);
                event = eventPool.take();
                event.events = 1;
                event.data.fd = stderrFd;
                rc = LibEpoll.epoll_ctl(this.epoll, 1, stderrFd, event);
                if (rc == -1) {
                    rc = Native.getLastError();
                    eventPool.put(event);
                    throw new RuntimeException("Unable to register new events to epoll, errorcode: " + rc);
                }
                eventPool.put(event);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        finally {
            if (stdinFd != null) {
                process.getStdin().release();
            }
            if (stdoutFd != null) {
                process.getStdout().release();
            }
            if (stderrFd != null) {
                process.getStderr().release();
            }
        }
    }

    @Override
    public void queueWrite(LinuxProcess process) {
        if (this.shutdown) {
            return;
        }
        try {
            int stdin = process.getStdin().acquire();
            if (stdin == -1) {
                return;
            }
            EpollEvent event = eventPool.take();
            event.events = 1073750036;
            event.data.fd = stdin;
            int rc = LibEpoll.epoll_ctl(this.epoll, 3, stdin, event);
            if (rc == -1) {
                rc = LibEpoll.epoll_ctl(this.epoll, 2, stdin, event);
                rc = LibEpoll.epoll_ctl(this.epoll, 1, stdin, event);
            }
            eventPool.put(event);
            if (rc == -1) {
                throw new RuntimeException("Unable to register new event to epoll queue");
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            process.getStdin().release();
        }
    }

    @Override
    public void closeStdin(LinuxProcess process) {
        try {
            int stdin = process.getStdin().acquire();
            if (stdin != -1) {
                this.fildesToProcessMap.remove(stdin);
                LibEpoll.epoll_ctl(this.epoll, 2, stdin, null);
            }
        }
        finally {
            process.getStdin().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() {
        Integer stdinFd = null;
        Integer stdoutFd = null;
        Integer stderrFd = null;
        BasePosixProcess linuxProcess = null;
        try {
            int nev = LibEpoll.epoll_wait(this.epoll, this.triggeredEvent, 1, DEADPOOL_POLL_INTERVAL);
            if (nev == -1) {
                throw new RuntimeException("Error waiting for epoll");
            }
            if (nev == 0) {
                boolean bl = false;
                return bl;
            }
            EpollEvent epEvent = this.triggeredEvent;
            int ident = epEvent.data.fd;
            int events = epEvent.events;
            linuxProcess = (LinuxProcess)this.fildesToProcessMap.get(ident);
            if (linuxProcess == null) {
                boolean bl = true;
                return bl;
            }
            stdinFd = linuxProcess.getStdin().acquire();
            stdoutFd = linuxProcess.getStdout().acquire();
            stderrFd = linuxProcess.getStderr().acquire();
            if ((events & 1) != 0) {
                if (ident == stdoutFd) {
                    linuxProcess.readStdout(65536, stdoutFd);
                } else if (ident == stderrFd) {
                    linuxProcess.readStderr(65536, stderrFd);
                }
            } else if ((events & 4) != 0 && stdinFd != -1 && linuxProcess.writeStdin(65536, stdinFd)) {
                epEvent.events = 1073750036;
                LibEpoll.epoll_ctl(this.epoll, 3, ident, epEvent);
            }
            if ((events & 0x10) != 0 || (events & 0x2000) != 0 || (events & 8) != 0) {
                LibEpoll.epoll_ctl(this.epoll, 2, ident, null);
                if (ident == stdoutFd) {
                    linuxProcess.readStdout(-1, stdoutFd);
                } else if (ident == stderrFd) {
                    linuxProcess.readStderr(-1, stderrFd);
                } else if (ident == stdinFd) {
                    linuxProcess.closeStdin(true);
                }
            }
            if (linuxProcess.isSoftExit()) {
                this.cleanupProcess((LinuxProcess)linuxProcess, stdinFd, stdoutFd, stderrFd);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (linuxProcess != null) {
                if (stdinFd != null) {
                    linuxProcess.getStdin().release();
                }
                if (stdoutFd != null) {
                    linuxProcess.getStdout().release();
                }
                if (stderrFd != null) {
                    linuxProcess.getStderr().release();
                }
            }
            this.triggeredEvent.clear();
            this.checkDeadPool();
        }
    }

    private void cleanupProcess(LinuxProcess linuxProcess, Integer stdinFd, Integer stdoutFd, Integer stderrFd) {
        this.pidToProcessMap.remove(linuxProcess.getPid());
        this.fildesToProcessMap.remove(stdinFd);
        this.fildesToProcessMap.remove(stdoutFd);
        this.fildesToProcessMap.remove(stderrFd);
        if (linuxProcess.cleanlyExitedBeforeProcess.get()) {
            linuxProcess.onExit(0);
            return;
        }
        IntByReference ret = new IntByReference();
        int rc = LibC.waitpid(linuxProcess.getPid(), ret, 1);
        if (rc == 0) {
            this.deadPool.add(linuxProcess);
        } else if (rc < 0) {
            linuxProcess.onExit(Native.getLastError() == 10 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        } else {
            int status = ret.getValue();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    linuxProcess.onExit(Integer.MIN_VALUE);
                } else {
                    linuxProcess.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                linuxProcess.onExit(LibC.WTERMSIG(status));
            } else {
                linuxProcess.onExit(Integer.MIN_VALUE);
            }
        }
    }

    private void checkDeadPool() {
        if (this.deadPool.isEmpty()) {
            return;
        }
        IntByReference ret = new IntByReference();
        Iterator<LinuxProcess> iterator = this.deadPool.iterator();
        while (iterator.hasNext()) {
            LinuxProcess process = iterator.next();
            int rc = LibC.waitpid(process.getPid(), ret, 1);
            if (rc == 0) continue;
            iterator.remove();
            if (rc < 0) {
                process.onExit(Native.getLastError() == 10 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                continue;
            }
            int status = ret.getValue();
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    process.onExit(Integer.MIN_VALUE);
                    continue;
                }
                process.onExit(status);
                continue;
            }
            if (LibC.WIFSIGNALED(status)) {
                process.onExit(LibC.WTERMSIG(status));
                continue;
            }
            process.onExit(Integer.MIN_VALUE);
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            eventPool.add(new EpollEvent());
        }
    }
}

