/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess;

import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessFactory;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NuProcessBuilder {
    private static final NuProcessFactory factory;
    private final List<String> command;
    private final TreeMap<String, String> environment;
    private Path cwd;
    private NuProcessHandler processListener;

    public NuProcessBuilder(List<String> commands, Map<String, String> environment) {
        if (commands == null || commands.isEmpty()) {
            throw new IllegalArgumentException("List of commands may not be null or empty");
        }
        this.environment = new TreeMap<String, String>(environment);
        this.command = new ArrayList<String>(commands);
    }

    public NuProcessBuilder(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            throw new IllegalArgumentException("List of commands may not be null or empty");
        }
        this.environment = new TreeMap<String, String>(System.getenv());
        this.command = new ArrayList<String>(commands);
    }

    public NuProcessBuilder(String ... commands) {
        if (commands == null || commands.length == 0) {
            throw new IllegalArgumentException("List of commands may not be null or empty");
        }
        this.environment = new TreeMap<String, String>(System.getenv());
        this.command = new ArrayList<String>(Arrays.asList(commands));
    }

    public NuProcessBuilder(NuProcessHandler nuProcessHandler, String ... commands) {
        this(commands);
        if (nuProcessHandler == null) {
            throw new IllegalArgumentException("A NuProcessListener must be specified");
        }
        this.processListener = nuProcessHandler;
    }

    public NuProcessBuilder(NuProcessHandler nuProcessHandler, List<String> commands) {
        this(commands);
        if (nuProcessHandler == null) {
            throw new IllegalArgumentException("A NuProcessListener must be specified");
        }
        this.processListener = nuProcessHandler;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public void setProcessListener(NuProcessHandler listener) {
        if (listener == null) {
            throw new IllegalArgumentException("A NuProcessListener must be specified");
        }
        this.processListener = listener;
    }

    public void setCwd(Path cwd) {
        this.cwd = cwd;
    }

    public NuProcess start() {
        if (this.processListener == null) {
            throw new IllegalArgumentException("NuProcessHandler not specified");
        }
        String[] env = new String[this.environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entrySet : this.environment.entrySet()) {
            env[i++] = entrySet.getKey() + "=" + entrySet.getValue();
        }
        return factory.createProcess(this.command, env, this.processListener, this.cwd);
    }

    static {
        String factoryClassName = null;
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("mac") || osname.contains("freebsd")) {
            factoryClassName = "com.zaxxer.nuprocess.osx.OsxProcessFactory";
        } else if (osname.contains("win")) {
            factoryClassName = "com.zaxxer.nuprocess.windows.WinProcessFactory";
        } else if (osname.contains("linux")) {
            factoryClassName = "com.zaxxer.nuprocess.linux.LinProcessFactory";
        } else if (osname.contains("sunos")) {
            factoryClassName = "com.zaxxer.nuprocess.solaris.SolProcessFactory";
        }
        if (factoryClassName == null) {
            throw new RuntimeException("Unsupported operating system: " + osname);
        }
        try {
            Class<?> forName = Class.forName(factoryClassName);
            factory = (NuProcessFactory)forName.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

