/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BaseEventProcessor;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.ProcessEpoll;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LinuxProcess
extends BasePosixProcess {
    private static final boolean LINUX_USE_VFORK = Boolean.parseBoolean(System.getProperty("com.zaxxer.nuprocess.linuxUseVfork", "true"));
    private static ExecutorService linuxCwdExecutorService;

    public LinuxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    @Override
    protected short getSpawnFlags() {
        if (LINUX_USE_VFORK) {
            return 64;
        }
        return 0;
    }

    @Override
    protected Pointer createPosixSpawnFileActions() {
        long peer = Native.malloc((long)80L);
        Pointer posix_spawn_file_actions = new Pointer(peer);
        return posix_spawn_file_actions;
    }

    @Override
    protected Pointer createPosixSpawnAttributes() {
        long peer = Native.malloc((long)340L);
        return new Pointer(peer);
    }

    @Override
    protected int spawnWithCwd(final IntByReference restrict_pid, final String restrict_path, final Pointer file_actions, final Pointer restrict_attrp, final StringArray argv, final Pointer envp, final Path cwd) {
        Future<Integer> setCwdThenSpawnFuture = linuxCwdExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                int rc = LibC.chdir(cwd.toAbsolutePath().toString());
                LinuxProcess.checkReturnCode(rc, "chdir() failed");
                return LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
            }
        });
        try {
            return setCwdThenSpawnFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean checkLaunch() {
        boolean cleanExit;
        IntByReference ret = new IntByReference();
        int waitpidRc = LibC.waitpid(this.pid, ret, 1);
        int status = ret.getValue();
        boolean bl = cleanExit = waitpidRc == this.pid && LibC.WIFEXITED(status) && LibC.WEXITSTATUS(status) == 0;
        if (cleanExit) {
            this.cleanlyExitedBeforeProcess.set(true);
        } else if (waitpidRc != 0) {
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    this.onExit(Integer.MIN_VALUE);
                } else {
                    this.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                this.onExit(LibC.WTERMSIG(status));
            }
            return false;
        }
        return true;
    }

    @Override
    protected void deallocateStructures(Pointer posix_spawn_file_actions, Pointer posix_spawnattr) {
        Native.free((long)Pointer.nativeValue((Pointer)posix_spawn_file_actions));
        Native.free((long)Pointer.nativeValue((Pointer)posix_spawnattr));
    }

    static {
        LibEpoll.sigignore(13);
        for (int i = 0; i < processors.length; ++i) {
            LinuxProcess.processors[i] = new ProcessEpoll();
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(processors.length, processors.length, BaseEventProcessor.LINGER_TIME_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new BasePosixProcess.LinuxCwdThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        executor.allowCoreThreadTimeOut(true);
        linuxCwdExecutorService = executor;
    }
}

