/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.LinuxLibC;
import com.zaxxer.nuprocess.internal.ReferenceCountedFileDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasePosixProcess
implements NuProcess {
    private static final boolean IS_SOFTEXIT_DETECTION;
    private static final ByteBuffer STDIN_CLOSED_PENDING_WRITE_TOMBSTONE;
    protected static final IEventProcessor<? extends BasePosixProcess>[] processors;
    protected static int processorRoundRobin;
    protected IEventProcessor<? super BasePosixProcess> myProcessor;
    protected volatile NuProcessHandler processHandler;
    protected volatile int pid;
    protected volatile boolean isRunning;
    public final AtomicBoolean cleanlyExitedBeforeProcess;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected AtomicBoolean userWantsWrite;
    private Memory outBufferMemory;
    private Memory errBufferMemory;
    private Memory inBufferMemory;
    protected ByteBuffer outBuffer;
    protected ByteBuffer errBuffer;
    protected ByteBuffer inBuffer;
    protected ReferenceCountedFileDescriptor stdin;
    protected ReferenceCountedFileDescriptor stdout;
    protected ReferenceCountedFileDescriptor stderr;
    protected volatile int stdinWidow;
    protected volatile int stdoutWidow;
    protected volatile int stderrWidow;
    protected AtomicBoolean stdinClosing;
    protected boolean outClosed;
    protected boolean errClosed;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;

    protected BasePosixProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.cleanlyExitedBeforeProcess = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.stdin = new ReferenceCountedFileDescriptor(-1);
        this.stdout = new ReferenceCountedFileDescriptor(-1);
        this.stderr = new ReferenceCountedFileDescriptor(-1);
        this.stdinClosing = new AtomicBoolean();
        this.outClosed = true;
        this.errClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] commands = command.toArray(new String[command.size()]);
        Pointer posix_spawn_file_actions = this.createPipes();
        Pointer posix_spawnattr = this.createPosixSpawnAttributes();
        try {
            int rc = LibC.posix_spawnattr_init(posix_spawnattr);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
            LibC.posix_spawnattr_setflags(posix_spawnattr, this.getSpawnFlags());
            IntByReference restrict_pid = new IntByReference();
            StringArray commandsArray = new StringArray(commands);
            StringArray environmentArray = new StringArray(environment);
            rc = cwd != null ? this.spawnWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray, cwd) : LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray);
            this.pid = restrict_pid.getValue();
            this.initializeBuffers();
            if (!this.checkLaunch()) {
                NuProcess nuProcess = null;
                return nuProcess;
            }
            BasePosixProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.registerProcess();
            this.callStart();
            this.singleProcessContinue();
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.err);
            this.onExit(Integer.MIN_VALUE);
            NuProcess nuProcess = null;
            return nuProcess;
        }
        finally {
            LibC.posix_spawnattr_destroy(posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            LibC.close(this.stdinWidow);
            LibC.close(this.stdoutWidow);
            LibC.close(this.stderrWidow);
            this.deallocateStructures(posix_spawn_file_actions, posix_spawnattr);
        }
        return this;
    }

    protected abstract short getSpawnFlags();

    protected abstract int spawnWithCwd(IntByReference var1, String var2, Pointer var3, Pointer var4, StringArray var5, Pointer var6, Path var7);

    protected boolean checkLaunch() {
        return true;
    }

    protected void deallocateStructures(Pointer posix_spawn_file_actions, Pointer posix_spawnattr) {
    }

    protected void singleProcessContinue() {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void destroy(boolean force) {
        if (this.isRunning) {
            BasePosixProcess.checkReturnCode(LibC.kill(this.pid, force ? 9 : 15), "Sending signal failed");
        }
    }

    @Override
    public void wantWrite() {
        block4: {
            try {
                int fd = this.stdin.acquire();
                if (fd != -1) {
                    this.userWantsWrite.set(true);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeStdin(boolean force) {
        if (force) {
            try {
                int fd = this.stdin.acquire();
                if (fd == -1) return;
                if (this.myProcessor != null) {
                    this.myProcessor.closeStdin(this);
                }
                this.stdin.close();
                return;
            }
            finally {
                this.stdin.release();
            }
        } else {
            if (!this.stdinClosing.compareAndSet(false, true)) throw new IllegalStateException("closeStdin() method has already been called.");
            this.pendingWrites.add(STDIN_CLOSED_PENDING_WRITE_TOMBSTONE);
            this.myProcessor.queueWrite(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStdin(ByteBuffer buffer) {
        block4: {
            try {
                int fd = this.stdin.acquire();
                boolean closing = this.stdinClosing.get();
                if (fd != -1 && !closing) {
                    this.pendingWrites.add(buffer);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    public int getPid() {
        return this.pid;
    }

    @Override
    public int getPID() {
        return this.pid;
    }

    public ReferenceCountedFileDescriptor getStdin() {
        return this.stdin;
    }

    public ReferenceCountedFileDescriptor getStdout() {
        return this.stdout;
    }

    public ReferenceCountedFileDescriptor getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return IS_SOFTEXIT_DETECTION && this.outClosed && this.errClosed;
    }

    public void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin(true);
            this.stdout.close();
            this.stderr.close();
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.outBuffer != null && !this.outClosed) {
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
            }
            if (this.errBuffer != null && !this.errClosed) {
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
            }
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.exitPending.countDown();
            this.outBufferMemory = null;
            this.errBufferMemory = null;
            this.inBufferMemory = null;
            this.outBuffer = null;
            this.errBuffer = null;
            this.inBuffer = null;
            this.processHandler = null;
            Memory.purge();
        }
    }

    public void readStdout(int availability, int fd) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.outBuffer, Math.min(availability, this.outBuffer.remaining()));
            if (read == -1) {
                this.outClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.limit(this.outBuffer.position() + read);
            this.outBuffer.position(0);
            this.processHandler.onStdout(this.outBuffer, false);
            this.outBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.outBuffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    public void readStderr(int availability, int fd) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.errBuffer, Math.min(availability, this.errBuffer.remaining()));
            if (read == -1) {
                this.errClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.errBuffer.limit(this.errBuffer.position() + read);
            this.errBuffer.position(0);
            this.processHandler.onStderr(this.errBuffer, false);
            this.errBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.errBuffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    public boolean writeStdin(int availability, int fd) {
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.inBuffer.hasRemaining()) {
            int wrote;
            do {
                if ((wrote = LibC.write(fd, this.inBuffer, Math.min(availability, this.inBuffer.remaining()))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                this.stdin.close();
                return false;
            } while (wrote < 0);
            availability -= wrote;
            this.inBuffer.position(this.inBuffer.position() + wrote);
            if (this.inBuffer.hasRemaining()) {
                return true;
            }
        }
        if (!this.pendingWrites.isEmpty()) {
            this.inBuffer.clear();
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer == STDIN_CLOSED_PENDING_WRITE_TOMBSTONE) {
                this.closeStdin(true);
                this.userWantsWrite.set(false);
                this.pendingWrites.clear();
                return false;
            }
            if (byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
            } else {
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            this.inBuffer.flip();
            if (this.inBuffer.hasRemaining()) {
                if (availability <= 0) {
                    return true;
                }
                return this.writeStdin(availability, fd);
            }
        }
        if (!this.userWantsWrite.get()) {
            return false;
        }
        try {
            this.inBuffer.clear();
            boolean wantMore = this.processHandler.onStdinReady(this.inBuffer);
            this.userWantsWrite.set(wantMore);
            if (this.inBuffer.hasRemaining() && availability > 0) {
                return this.writeStdin(availability, fd);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Exception thrown handling writes to stdin " + this.processHandler, e);
            return false;
        }
    }

    protected void afterStart() {
        this.isRunning = true;
    }

    protected void initializeBuffers() {
        this.outClosed = false;
        this.errClosed = false;
        this.pendingWrites = new ConcurrentLinkedQueue();
        this.outBufferMemory = new Memory(65536L);
        this.outBuffer = this.outBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.errBufferMemory = new Memory(65536L);
        this.errBuffer = this.errBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBufferMemory = new Memory(65536L);
        this.inBuffer = this.inBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerProcess() {
        IEventProcessor<? extends BasePosixProcess>[] iEventProcessorArray = processors;
        synchronized (processors) {
            int mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread(this.myProcessor, "ProcessQueue" + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    protected void callPreStart() {
        try {
            this.processHandler.onPreStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Pointer createPipes() {
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        Pointer posix_spawn_file_actions = this.createPosixSpawnFileActions();
        try {
            int rc = LibC.pipe(in);
            BasePosixProcess.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            BasePosixProcess.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            BasePosixProcess.checkReturnCode(rc, "Create stderr pipe() failed");
            rc = LibC.posix_spawn_file_actions_init(posix_spawn_file_actions);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, in[0], 0);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, in[1]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdin = new ReferenceCountedFileDescriptor(in[1]);
            this.stdinWidow = in[0];
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, out[1], 1);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, out[0]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdout = new ReferenceCountedFileDescriptor(out[0]);
            this.stdoutWidow = out[1];
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, err[1], 2);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, err[0]);
            BasePosixProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stderr = new ReferenceCountedFileDescriptor(err[0]);
            this.stderrWidow = err[1];
            this.setNonBlocking(in, out, err);
            return posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    protected abstract Pointer createPosixSpawnFileActions();

    protected abstract Pointer createPosixSpawnAttributes();

    protected void setNonBlocking(int[] in, int[] out, int[] err) {
        int rc = LibC.fcntl(in[1], 4, LibC.fcntl(in[1], 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
        rc = LibC.fcntl(out[0], 4, LibC.fcntl(out[0], 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
        rc = LibC.fcntl(err[0], 4, LibC.fcntl(err[0], 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
    }

    private void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            LibC.close(fildes);
        }
    }

    protected static void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    static {
        STDIN_CLOSED_PENDING_WRITE_TOMBSTONE = ByteBuffer.allocate(1);
        IS_SOFTEXIT_DETECTION = Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
        String threads = System.getProperty("com.zaxxer.nuprocess.threads", "auto");
        int numThreads = "auto".equals(threads) ? Math.max(1, Runtime.getRuntime().availableProcessors() / 2) : ("cores".equals(threads) ? Runtime.getRuntime().availableProcessors() : Math.max(1, Integer.parseInt(threads)));
        processors = new IEventProcessor[numThreads];
        if (Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true")).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (IEventProcessor<? extends BasePosixProcess> processor : processors) {
                        if (processor == null) continue;
                        processor.shutdown();
                    }
                }
            }));
        }
    }

    public static class LinuxCwdThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(final Runnable r) {
            Runnable unshareCwdThenSpawn = new Runnable(){

                @Override
                public void run() {
                    int rc = LinuxLibC.unshare(512);
                    BasePosixProcess.checkReturnCode(rc, "unshare(CLONE_FS) failed");
                    r.run();
                }
            };
            Thread newThread = Executors.defaultThreadFactory().newThread(unshareCwdThenSpawn);
            newThread.setName(String.format("NuProcessLinuxCwdChangeable-%d", this.threadCount.incrementAndGet()));
            return newThread;
        }
    }
}

