/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.ProcessEpoll;

public class LinuxProcess
extends BasePosixProcess {
    LinuxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    @Override
    protected boolean checkLaunch() {
        boolean cleanExit;
        IntByReference ret = new IntByReference();
        int waitpidRc = LibC.waitpid(this.pid, ret, 1);
        int status = ret.getValue();
        boolean bl = cleanExit = waitpidRc == this.pid && LibC.WIFEXITED(status) && LibC.WEXITSTATUS(status) == 0;
        if (cleanExit) {
            this.cleanlyExitedBeforeProcess.set(true);
        } else if (waitpidRc != 0) {
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    this.onExit(Integer.MIN_VALUE);
                } else {
                    this.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                this.onExit(LibC.WTERMSIG(status));
            }
            return false;
        }
        return true;
    }

    static {
        LibEpoll.sigignore(13);
        for (int i = 0; i < processors.length; ++i) {
            LinuxProcess.processors[i] = new ProcessEpoll();
        }
    }
}

