/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.JNIEnv;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.Constants;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.LibJava8;
import com.zaxxer.nuprocess.internal.ReferenceCountedFileDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasePosixProcess
implements NuProcess {
    private static final boolean IS_SOFTEXIT_DETECTION;
    private static final ByteBuffer STDIN_CLOSED_PENDING_WRITE_TOMBSTONE;
    protected static final IEventProcessor<? extends BasePosixProcess>[] processors;
    protected static int processorRoundRobin;
    private int exitcode;
    protected IEventProcessor<? super BasePosixProcess> myProcessor;
    protected volatile NuProcessHandler processHandler;
    protected volatile int pid;
    protected volatile boolean isRunning;
    public final AtomicBoolean cleanlyExitedBeforeProcess;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected AtomicBoolean userWantsWrite;
    private Memory outBufferMemory;
    private Memory errBufferMemory;
    private Memory inBufferMemory;
    protected ByteBuffer outBuffer;
    protected ByteBuffer errBuffer;
    protected ByteBuffer inBuffer;
    protected ReferenceCountedFileDescriptor stdin;
    protected ReferenceCountedFileDescriptor stdout;
    protected ReferenceCountedFileDescriptor stderr;
    protected AtomicBoolean stdinClosing;
    protected boolean outClosed;
    protected boolean errClosed;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;

    protected BasePosixProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.cleanlyExitedBeforeProcess = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.stdin = new ReferenceCountedFileDescriptor(-1);
        this.stdout = new ReferenceCountedFileDescriptor(-1);
        this.stderr = new ReferenceCountedFileDescriptor(-1);
        this.stdinClosing = new AtomicBoolean();
        this.outClosed = true;
        this.errClosed = true;
    }

    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] cmdarray = command.toArray(new String[0]);
        byte[][] args = new byte[cmdarray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdarray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        byte[] envBlock = BasePosixProcess.toEnvironmentBlock(environment);
        int[] std_fds = new int[]{-1, -1, -1};
        try {
            LaunchMechanism launchMechanism = Constants.OS == Constants.OperatingSystem.MAC ? LaunchMechanism.POSIX_SPAWN : LaunchMechanism.VFORK;
            this.pid = LibJava8.Java_java_lang_UNIXProcess_forkAndExec(JNIEnv.CURRENT, this, launchMechanism.ordinal() + 1, BasePosixProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), BasePosixProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, environment.length, cwd != null ? BasePosixProcess.toCString(cwd.toString()) : null, std_fds, (byte)0);
            if (this.pid == -1 || !this.checkLaunch()) {
                return null;
            }
            this.stdin = new ReferenceCountedFileDescriptor(std_fds[0]);
            this.stdout = new ReferenceCountedFileDescriptor(std_fds[1]);
            this.stderr = new ReferenceCountedFileDescriptor(std_fds[2]);
            this.initializeBuffers();
            this.setNonBlocking(std_fds[0], std_fds[1], std_fds[2]);
            this.afterStart();
            this.registerProcess();
            this.callStart();
        }
        catch (Exception re) {
            re.printStackTrace(System.err);
            this.onExit(Integer.MIN_VALUE);
            return null;
        }
        return this;
    }

    protected boolean checkLaunch() {
        return true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void destroy(boolean force) {
        if (this.isRunning) {
            BasePosixProcess.checkReturnCode(LibC.kill(this.pid, force ? 9 : 15), "Sending signal failed");
        }
    }

    @Override
    public void wantWrite() {
        block4: {
            try {
                int fd = this.stdin.acquire();
                if (fd != -1) {
                    this.userWantsWrite.set(true);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeStdin(boolean force) {
        if (force) {
            try {
                int fd = this.stdin.acquire();
                if (fd == -1) return;
                if (this.myProcessor != null) {
                    this.myProcessor.closeStdin(this);
                }
                this.stdin.close();
                return;
            }
            finally {
                this.stdin.release();
            }
        } else {
            if (!this.stdinClosing.compareAndSet(false, true)) throw new IllegalStateException("closeStdin() method has already been called.");
            this.pendingWrites.add(STDIN_CLOSED_PENDING_WRITE_TOMBSTONE);
            this.myProcessor.queueWrite(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStdin(ByteBuffer buffer) {
        block4: {
            try {
                int fd = this.stdin.acquire();
                boolean closing = this.stdinClosing.get();
                if (fd != -1 && !closing) {
                    this.pendingWrites.add(buffer);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    public int getPid() {
        return this.pid;
    }

    @Override
    public int getPID() {
        return this.pid;
    }

    public ReferenceCountedFileDescriptor getStdin() {
        return this.stdin;
    }

    public ReferenceCountedFileDescriptor getStdout() {
        return this.stdout;
    }

    public ReferenceCountedFileDescriptor getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return IS_SOFTEXIT_DETECTION && this.outClosed && this.errClosed;
    }

    public void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin(true);
            this.stdout.close();
            this.stderr.close();
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.outBuffer != null && !this.outClosed) {
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
            }
            if (this.errBuffer != null && !this.errClosed) {
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
            }
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.exitPending.countDown();
            this.outBufferMemory = null;
            this.errBufferMemory = null;
            this.inBufferMemory = null;
            this.outBuffer = null;
            this.errBuffer = null;
            this.inBuffer = null;
            this.processHandler = null;
            Memory.purge();
        }
    }

    public void readStdout(int availability, int fd) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.outBuffer, Math.min(availability, this.outBuffer.remaining()));
            if (read == -1) {
                this.outClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.outBuffer.limit(this.outBuffer.position() + read);
            this.outBuffer.position(0);
            this.processHandler.onStdout(this.outBuffer, false);
            this.outBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.outBuffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    public void readStderr(int availability, int fd) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.errBuffer, Math.min(availability, this.errBuffer.remaining()));
            if (read == -1) {
                this.errClosed = true;
                throw new RuntimeException("Unexpected eof");
            }
            this.errBuffer.limit(this.errBuffer.position() + read);
            this.errBuffer.position(0);
            this.processHandler.onStderr(this.errBuffer, false);
            this.errBuffer.compact();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (!this.errBuffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    public boolean writeStdin(int availability, int fd) {
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.inBuffer.hasRemaining()) {
            int wrote;
            do {
                if ((wrote = LibC.write(fd, this.inBuffer, Math.min(availability, this.inBuffer.remaining()))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                this.stdin.close();
                return false;
            } while (wrote < 0);
            availability -= wrote;
            this.inBuffer.position(this.inBuffer.position() + wrote);
            if (this.inBuffer.hasRemaining()) {
                return true;
            }
        }
        if (!this.pendingWrites.isEmpty()) {
            this.inBuffer.clear();
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer == STDIN_CLOSED_PENDING_WRITE_TOMBSTONE) {
                this.closeStdin(true);
                this.userWantsWrite.set(false);
                this.pendingWrites.clear();
                return false;
            }
            if (byteBuffer != null && byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
            } else if (byteBuffer != null) {
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            this.inBuffer.flip();
            if (this.inBuffer.hasRemaining()) {
                if (availability <= 0) {
                    return true;
                }
                return this.writeStdin(availability, fd);
            }
        }
        if (!this.userWantsWrite.get()) {
            return false;
        }
        try {
            this.inBuffer.clear();
            boolean wantMore = this.processHandler.onStdinReady(this.inBuffer);
            this.userWantsWrite.set(wantMore);
            if (this.inBuffer.hasRemaining() && availability > 0) {
                return this.writeStdin(availability, fd);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Exception thrown handling writes to stdin " + this.processHandler, e);
            return false;
        }
    }

    protected void afterStart() {
        this.isRunning = true;
    }

    protected void initializeBuffers() {
        this.outClosed = false;
        this.errClosed = false;
        this.pendingWrites = new ConcurrentLinkedQueue();
        this.outBufferMemory = new Memory(65536L);
        this.outBuffer = this.outBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.errBufferMemory = new Memory(65536L);
        this.errBuffer = this.errBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBufferMemory = new Memory(65536L);
        this.inBuffer = this.inBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerProcess() {
        IEventProcessor<? extends BasePosixProcess>[] iEventProcessorArray = processors;
        synchronized (processors) {
            int mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread(this.myProcessor, "ProcessQueue" + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    protected void callPreStart() {
        try {
            this.processHandler.onPreStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setNonBlocking(int in, int out, int err) {
        int rc = LibC.fcntl(in, 4, LibC.fcntl(in, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
        rc = LibC.fcntl(out, 4, LibC.fcntl(out, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
        rc = LibC.fcntl(err, 4, LibC.fcntl(err, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
    }

    protected static void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private static byte[] toEnvironmentBlock(String[] environment) {
        int count = environment.length;
        for (String entry : environment) {
            count += entry.getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (String entry : environment) {
            byte[] bytes = entry.getBytes();
            System.arraycopy(bytes, 0, block, i, bytes.length);
            i += bytes.length + 1;
        }
        return block;
    }

    static {
        STDIN_CLOSED_PENDING_WRITE_TOMBSTONE = ByteBuffer.allocate(1);
        IS_SOFTEXIT_DETECTION = Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
        processors = new IEventProcessor[Constants.NUMBER_OF_THREADS];
        if (Boolean.valueOf(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true")).booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (IEventProcessor<? extends BasePosixProcess> processor : processors) {
                        if (processor == null) continue;
                        processor.shutdown();
                    }
                }
            }));
        }
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

