/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.Arrays;
import java.util.List;

class EpollEvent {
    private static final int eventsOffset;
    private static final int fdOffset;
    private static final int size;
    private final Pointer pointer = new Memory((long)size);

    EpollEvent() {
    }

    int getEvents() {
        return this.pointer.getInt((long)eventsOffset);
    }

    void setEvents(int mask) {
        this.pointer.setInt((long)eventsOffset, mask);
    }

    void setFileDescriptor(int fd) {
        this.pointer.setInt((long)fdOffset, fd);
    }

    int getFileDescriptor() {
        return this.pointer.getInt((long)fdOffset);
    }

    Pointer getPointer() {
        return this.pointer;
    }

    int size() {
        return size;
    }

    static {
        EpollEventPrototype event = new EpollEventPrototype();
        eventsOffset = event.getFieldOffset("events");
        fdOffset = event.getFieldOffset("data");
        size = event.size();
    }

    public static class EpollEventPrototype
    extends Structure {
        public int events;
        public EpollData data = new EpollData();

        EpollEventPrototype() {
            super(1);
            this.data.setType("fd");
        }

        int getFieldOffset(String field) {
            return this.fieldOffset(field);
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("events", "data");
        }

        public static class EpollData
        extends Union {
            public int fd;
            public int u32;
            public long u64;
        }
    }
}

