/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.ReferenceCountedFileDescriptor;
import com.zaxxer.nuprocess.osx.ProcessKqueue;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class OsxProcess
extends BasePosixProcess {
    private volatile int stdinWidow;
    private volatile int stdoutWidow;
    private volatile int stderrWidow;

    OsxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] commands = command.toArray(new String[0]);
        Pointer posix_spawn_file_actions = this.createPipes();
        Pointer posix_spawnattr = this.createPosixSpawnAttributes();
        try {
            int rc = LibC.posix_spawnattr_init(posix_spawnattr);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
            LibC.posix_spawnattr_setflags(posix_spawnattr, (short)16512);
            IntByReference restrict_pid = new IntByReference();
            StringArray commandsArray = new StringArray(commands);
            StringArray environmentArray = new StringArray(environment);
            rc = cwd != null ? this.spawnWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray, cwd) : LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray);
            this.pid = restrict_pid.getValue();
            this.initializeBuffers();
            if (!this.checkLaunch()) {
                NuProcess nuProcess = null;
                return nuProcess;
            }
            OsxProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.registerProcess();
            this.callStart();
            this.singleProcessContinue();
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.err);
            this.onExit(Integer.MIN_VALUE);
            NuProcess nuProcess = null;
            return nuProcess;
        }
        finally {
            LibC.posix_spawnattr_destroy(posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            LibC.close(this.stdinWidow);
            LibC.close(this.stdoutWidow);
            LibC.close(this.stderrWidow);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spawnWithCwd(IntByReference restrict_pid, String restrict_path, Pointer file_actions, Pointer restrict_attrp, StringArray argv, Pointer envp, Path cwd) {
        int n;
        int cwdBufSize = 1024;
        long peer = Native.malloc((long)cwdBufSize);
        Pointer oldCwd = new Pointer(peer);
        LibC.getcwd(oldCwd, cwdBufSize);
        String newCwd = cwd.toAbsolutePath().toString();
        int rc = LibC.SYSCALL.syscall(348, newCwd);
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to set current directory");
        try {
            n = LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
        }
        catch (Throwable throwable) {
            rc = LibC.SYSCALL.syscall(348, oldCwd);
            Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
            OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
            throw throwable;
        }
        rc = LibC.SYSCALL.syscall(348, oldCwd);
        Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
        return n;
    }

    private void singleProcessContinue() {
        LibC.kill(this.pid, 19);
    }

    private Pointer createPipes() {
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        Pointer posix_spawn_file_actions = this.createPosixSpawnFileActions();
        try {
            int rc = LibC.pipe(in);
            OsxProcess.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            OsxProcess.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            OsxProcess.checkReturnCode(rc, "Create stderr pipe() failed");
            rc = LibC.posix_spawn_file_actions_init(posix_spawn_file_actions);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, in[0], 0);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, in[1]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdin = new ReferenceCountedFileDescriptor(in[1]);
            this.stdinWidow = in[0];
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, out[1], 1);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, out[0]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stdout = new ReferenceCountedFileDescriptor(out[0]);
            this.stdoutWidow = out[1];
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, err[1], 2);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, err[0]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            this.stderr = new ReferenceCountedFileDescriptor(err[0]);
            this.stderrWidow = err[1];
            this.setNonBlocking(in, out, err);
            return posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    private Pointer createPosixSpawnFileActions() {
        return new Memory((long)Pointer.SIZE);
    }

    private Pointer createPosixSpawnAttributes() {
        return new Memory((long)Pointer.SIZE);
    }

    private void setNonBlocking(int[] in, int[] out, int[] err) {
        int rc = LibC.fcntl(in[1], 4, LibC.fcntl(in[1], 3) | LibC.O_NONBLOCK);
        OsxProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
        rc = LibC.fcntl(out[0], 4, LibC.fcntl(out[0], 3) | LibC.O_NONBLOCK);
        OsxProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
        rc = LibC.fcntl(err[0], 4, LibC.fcntl(err[0], 3) | LibC.O_NONBLOCK);
        OsxProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
    }

    private void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            LibC.close(fildes);
        }
    }

    static {
        for (int i = 0; i < processors.length; ++i) {
            OsxProcess.processors[i] = new ProcessKqueue();
        }
        LibC.signal(31, LibC.SIG_IGN);
    }
}

