/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.JNIEnv;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.LibJava8;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.ProcessEpoll;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;

public class LinuxProcess
extends BasePosixProcess {
    LinuxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    @Override
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] cmdarray = command.toArray(new String[0]);
        byte[][] args = new byte[cmdarray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdarray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        byte[] envBlock = LinuxProcess.toEnvironmentBlock(environment);
        try {
            this.createPipes();
            int[] child_fds = new int[]{this.stdinWidow, this.stdoutWidow, this.stderrWidow};
            this.pid = LibJava8.Java_java_lang_UNIXProcess_forkAndExec(JNIEnv.CURRENT, this, LaunchMechanism.VFORK.ordinal() + 1, LinuxProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), LinuxProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, environment.length, cwd != null ? LinuxProcess.toCString(cwd.toString()) : null, child_fds, (byte)0);
            if (this.pid == -1) {
                return null;
            }
            LibC.close(this.stdinWidow);
            LibC.close(this.stdoutWidow);
            LibC.close(this.stderrWidow);
            this.initializeBuffers();
            this.afterStart();
            this.registerProcess();
            this.callStart();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to start process", e);
            this.onExit(Integer.MIN_VALUE);
            return null;
        }
        return this;
    }

    @Override
    protected boolean checkLaunch() {
        boolean cleanExit;
        IntByReference ret = new IntByReference();
        int waitpidRc = LibC.waitpid(this.pid, ret, 1);
        int status = ret.getValue();
        boolean bl = cleanExit = waitpidRc == this.pid && LibC.WIFEXITED(status) && LibC.WEXITSTATUS(status) == 0;
        if (cleanExit) {
            this.cleanlyExitedBeforeProcess.set(true);
        } else if (waitpidRc != 0) {
            if (LibC.WIFEXITED(status)) {
                if ((status = LibC.WEXITSTATUS(status)) == 127) {
                    this.onExit(Integer.MIN_VALUE);
                } else {
                    this.onExit(status);
                }
            } else if (LibC.WIFSIGNALED(status)) {
                this.onExit(LibC.WTERMSIG(status));
            }
            return false;
        }
        return true;
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private static byte[] toEnvironmentBlock(String[] environment) {
        int count = environment.length;
        for (String entry : environment) {
            count += entry.getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (String entry : environment) {
            byte[] bytes = entry.getBytes();
            System.arraycopy(bytes, 0, block, i, bytes.length);
            i += bytes.length + 1;
        }
        return block;
    }

    static {
        LibEpoll.sigignore(13);
        for (int i = 0; i < processors.length; ++i) {
            LinuxProcess.processors[i] = new ProcessEpoll();
        }
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

