/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import java.util.Formatter;

public final class HexDumpElf {
    private static final int MAX_VISIBLE = 127;
    private static final int MIN_VISIBLE = 31;

    private HexDumpElf() {
    }

    public static String dump(int displayOffset, byte[] data, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        StringBuilder ascii = new StringBuilder();
        int dataNdx = offset;
        int maxDataNdx = offset + len;
        int lines = (len + 16) / 16;
        for (int i = 0; i < lines; ++i) {
            ascii.append(" |");
            formatter.format("%08x  ", displayOffset + i * 16);
            for (int j = 0; j < 16; ++j) {
                if (dataNdx < maxDataNdx) {
                    byte b = data[dataNdx++];
                    formatter.format("%02x ", b);
                    ascii.append(b > 31 && b < 127 ? (char)b : (char)' ');
                } else {
                    sb.append("   ");
                }
                if (j != 7) continue;
                sb.append(' ');
            }
            ascii.append('|');
            sb.append((CharSequence)ascii).append('\n');
            ascii.setLength(0);
        }
        formatter.close();
        return sb.toString();
    }
}

