/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.LastErrorException;
import com.zaxxer.nuprocess.internal.LibC;

public class ReferenceCountedFileDescriptor {
    private int fd;
    private int fdRefCount;
    private boolean closePending;

    public ReferenceCountedFileDescriptor(int fd) {
        this.fd = fd;
        this.fdRefCount = 0;
        this.closePending = false;
    }

    protected void finalize() {
        this.close();
    }

    public synchronized int acquire() {
        ++this.fdRefCount;
        return this.fd;
    }

    public synchronized void release() {
        --this.fdRefCount;
        if (this.fdRefCount == 0 && this.closePending && this.fd != -1) {
            this.doClose();
        }
    }

    public synchronized void close() {
        if (this.fd == -1 || this.closePending) {
            return;
        }
        if (this.fdRefCount == 0) {
            this.doClose();
        } else {
            this.closePending = true;
        }
    }

    private void doClose() {
        try {
            LibC.close(this.fd);
            this.fd = -1;
        }
        catch (LastErrorException e) {
            throw new RuntimeException(e);
        }
    }
}

