/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.linux;

import com.sun.jna.JNIEnv;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.Constants;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.LibJava10;
import com.zaxxer.nuprocess.internal.LibJava8;
import com.zaxxer.nuprocess.linux.EpollEvent;
import com.zaxxer.nuprocess.linux.LibEpoll;
import com.zaxxer.nuprocess.linux.ProcessEpoll;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;

public class LinuxProcess
extends BasePosixProcess {
    private final EpollEvent epollEvent = new EpollEvent();

    LinuxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    @Override
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        try {
            this.prepareProcess(command, environment, cwd);
            if (this.pid == -1) {
                return null;
            }
            this.initializeBuffers();
            this.afterStart();
            this.registerProcess();
            this.callStart();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to start process", e);
            this.onExit(Integer.MIN_VALUE);
            return null;
        }
        return this;
    }

    @Override
    public void run(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        try {
            this.prepareProcess(command, environment, cwd);
            if (this.pid == -1) {
                return;
            }
            this.initializeBuffers();
            this.afterStart();
            this.myProcessor = new ProcessEpoll(this);
            this.callStart();
            this.myProcessor.run();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to start process", e);
            this.onExit(Integer.MIN_VALUE);
        }
    }

    EpollEvent getEpollEvent() {
        return this.epollEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareProcess(List<String> command, String[] environment, Path cwd) throws IOException {
        String[] cmdarray = command.toArray(new String[0]);
        byte[][] args = new byte[cmdarray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdarray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        byte[] envBlock = LinuxProcess.toEnvironmentBlock(environment);
        this.createPipes();
        try {
            int[] child_fds = new int[]{this.stdinWidow, this.stdoutWidow, this.stderrWidow};
            this.pid = Constants.JVM_MAJOR_VERSION >= 10 ? LibJava10.Java_java_lang_ProcessImpl_forkAndExec(JNIEnv.CURRENT, this, LaunchMechanism.VFORK.ordinal() + 1, LinuxProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), LinuxProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, environment.length, cwd != null ? LinuxProcess.toCString(cwd.toString()) : null, child_fds, (byte)0) : LibJava8.Java_java_lang_UNIXProcess_forkAndExec(JNIEnv.CURRENT, this, LaunchMechanism.VFORK.ordinal() + 1, LinuxProcess.toCString(System.getProperty("java.home") + "/lib/jspawnhelper"), LinuxProcess.toCString(cmdarray[0]), argBlock, args.length, envBlock, environment.length, cwd != null ? LinuxProcess.toCString(cwd.toString()) : null, child_fds, (byte)0);
        }
        finally {
            this.closePipes();
        }
    }

    private void closePipes() {
        LibC.close(this.stdinWidow);
        LibC.close(this.stdoutWidow);
        LibC.close(this.stderrWidow);
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private static byte[] toEnvironmentBlock(String[] environment) {
        int count = environment.length;
        for (String entry : environment) {
            count += entry.getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (String entry : environment) {
            byte[] bytes = entry.getBytes();
            System.arraycopy(bytes, 0, block, i, bytes.length);
            i += bytes.length + 1;
        }
        return block;
    }

    static {
        LibEpoll.sigignore(13);
        for (int i = 0; i < processors.length; ++i) {
            LinuxProcess.processors[i] = new ProcessEpoll();
        }
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

