/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import java.util.Arrays;
import java.util.List;

public interface NuWinNT {
    public static final int CREATE_SUSPENDED = 4;
    public static final int CREATE_UNICODE_ENVIRONMENT = 1024;
    public static final int CREATE_NO_WINDOW = 0x8000000;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_BROKEN_PIPE = 109;
    public static final int ERROR_PIPE_NOT_CONNECTED = 233;
    public static final int ERROR_PIPE_CONNECTED = 535;
    public static final int ERROR_IO_PENDING = 997;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    public static final int GENERIC_WRITE = 0x40000000;
    public static final int OPEN_EXISTING = 3;
    public static final int STATUS_PENDING = 259;
    public static final int STILL_ACTIVE = 259;
    public static final int STARTF_USESTDHANDLES = 256;
    public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(HANDLE.INVALID);

    public static class PROCESS_INFORMATION
    extends Structure {
        public HANDLE hProcess;
        public HANDLE hThread;
        public DWORD dwProcessId;
        public DWORD dwThreadId;

        protected List<String> getFieldOrder() {
            return Arrays.asList("hProcess", "hThread", "dwProcessId", "dwThreadId");
        }
    }

    public static class STARTUPINFO
    extends Structure {
        public DWORD cb = new DWORD(this.size());
        public String lpReserved;
        public String lpDesktop;
        public String lpTitle;
        public DWORD dwX;
        public DWORD dwY;
        public DWORD dwXSize;
        public DWORD dwYSize;
        public DWORD dwXCountChars;
        public DWORD dwYCountChars;
        public DWORD dwFillAttribute;
        public int dwFlags;
        public WORD wShowWindow;
        public WORD cbReserved2;
        public ByteByReference lpReserved2;
        public HANDLE hStdInput;
        public HANDLE hStdOutput;
        public HANDLE hStdError;

        protected List<String> getFieldOrder() {
            return Arrays.asList("cb", "lpReserved", "lpDesktop", "lpTitle", "dwX", "dwY", "dwXSize", "dwYSize", "dwXCountChars", "dwYCountChars", "dwFillAttribute", "dwFlags", "wShowWindow", "cbReserved2", "lpReserved2", "hStdInput", "hStdOutput", "hStdError");
        }
    }

    public static class SECURITY_ATTRIBUTES
    extends Structure {
        public DWORD dwLength;
        public Pointer lpSecurityDescriptor;
        public boolean bInheritHandle;

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwLength", "lpSecurityDescriptor", "bInheritHandle");
        }
    }

    public static class ULONG_PTRByReference
    extends ByReference {
        public ULONG_PTRByReference() {
            this(new ULONG_PTR(0L));
        }

        public ULONG_PTRByReference(ULONG_PTR value) {
            super(Native.POINTER_SIZE);
            this.setValue(value);
        }

        public void setValue(ULONG_PTR value) {
            if (Native.POINTER_SIZE == 4) {
                this.getPointer().setInt(0L, value.intValue());
            } else {
                this.getPointer().setLong(0L, value.longValue());
            }
        }

        public ULONG_PTR getValue() {
            return new ULONG_PTR(Native.POINTER_SIZE == 4 ? (long)this.getPointer().getInt(0L) : this.getPointer().getLong(0L));
        }
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long value) {
            super(Native.POINTER_SIZE, value, true);
        }
    }

    public static class DWORD
    extends IntegerType {
        public static final int SIZE = 4;

        public DWORD() {
            this(0L);
        }

        public DWORD(long value) {
            super(4, value, true);
        }
    }

    public static class WORD
    extends IntegerType {
        public static final int SIZE = 2;

        public WORD() {
            this(0L);
        }

        public WORD(long value) {
            super(2, value, true);
        }
    }

    public static class HANDLE
    extends PointerType {
        static final Pointer INVALID = Pointer.createConstant((long)(Native.POINTER_SIZE == 8 ? -1L : 0xFFFFFFFFL));

        public HANDLE() {
        }

        public HANDLE(Pointer p) {
            this.setPointer(p);
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            if (nativeValue == null) {
                return null;
            }
            Pointer ptr = (Pointer)nativeValue;
            if (INVALID.equals((Object)ptr)) {
                return INVALID_HANDLE_VALUE;
            }
            return new HANDLE(ptr);
        }
    }
}

