/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.osx;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.BasePosixProcess;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.osx.ProcessKqueue;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;

class OsxProcess
extends BasePosixProcess {
    OsxProcess(NuProcessHandler processListener) {
        super(processListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NuProcess start(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] commands = command.toArray(new String[0]);
        Pointer posix_spawn_file_actions = this.createPosixPipes();
        Pointer posix_spawnattr = this.createPosixSpawnAttributes();
        try {
            int rc = this.prepareProcess(environment, cwd, commands, posix_spawn_file_actions, posix_spawnattr);
            OsxProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.registerProcess();
            this.myProcessor.queueRead(this);
            this.callStart();
            this.singleProcessContinue();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
            this.onExit(Integer.MIN_VALUE);
            NuProcess nuProcess = null;
            return nuProcess;
        }
        finally {
            LibC.posix_spawnattr_destroy(posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            this.closePipes();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(List<String> command, String[] environment, Path cwd) {
        this.callPreStart();
        String[] commands = command.toArray(new String[0]);
        Pointer posix_spawn_file_actions = this.createPosixPipes();
        Pointer posix_spawnattr = this.createPosixSpawnAttributes();
        try {
            int rc = this.prepareProcess(environment, cwd, commands, posix_spawn_file_actions, posix_spawnattr);
            OsxProcess.checkReturnCode(rc, "Invocation of posix_spawn() failed");
            this.afterStart();
            this.myProcessor = new ProcessKqueue(this);
            this.callStart();
            this.singleProcessContinue();
            this.myProcessor.run();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
            this.onExit(Integer.MIN_VALUE);
        }
        finally {
            LibC.posix_spawnattr_destroy(posix_spawnattr);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            this.closePipes();
        }
    }

    private int prepareProcess(String[] environment, Path cwd, String[] commands, Pointer posix_spawn_file_actions, Pointer posix_spawnattr) {
        int rc = LibC.posix_spawnattr_init(posix_spawnattr);
        OsxProcess.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
        LibC.posix_spawnattr_setflags(posix_spawnattr, (short)16512);
        IntByReference restrict_pid = new IntByReference();
        StringArray commandsArray = new StringArray(commands);
        StringArray environmentArray = new StringArray(environment);
        rc = cwd != null ? this.spawnWithCwd(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray, cwd) : LibC.posix_spawnp(restrict_pid, commands[0], posix_spawn_file_actions, posix_spawnattr, commandsArray, (Pointer)environmentArray);
        this.pid = restrict_pid.getValue();
        this.initializeBuffers();
        return rc;
    }

    private void closePipes() {
        LibC.close(this.stdinWidow);
        LibC.close(this.stdoutWidow);
        LibC.close(this.stderrWidow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spawnWithCwd(IntByReference restrict_pid, String restrict_path, Pointer file_actions, Pointer restrict_attrp, StringArray argv, Pointer envp, Path cwd) {
        int n;
        int cwdBufSize = 1024;
        long peer = Native.malloc((long)cwdBufSize);
        Pointer oldCwd = new Pointer(peer);
        LibC.getcwd(oldCwd, cwdBufSize);
        String newCwd = cwd.toAbsolutePath().toString();
        int rc = LibC.SYSCALL.syscall(348, newCwd);
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to set current directory");
        try {
            n = LibC.posix_spawnp(restrict_pid, restrict_path, file_actions, restrict_attrp, argv, envp);
        }
        catch (Throwable throwable) {
            rc = LibC.SYSCALL.syscall(348, oldCwd);
            Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
            OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
            throw throwable;
        }
        rc = LibC.SYSCALL.syscall(348, oldCwd);
        Native.free((long)Pointer.nativeValue((Pointer)oldCwd));
        OsxProcess.checkReturnCode(rc, "syscall(SYS__pthread_chdir) failed to restore current directory");
        return n;
    }

    private void singleProcessContinue() {
        LibC.kill(this.pid, 19);
    }

    private Pointer createPosixPipes() {
        Pointer posix_spawn_file_actions = this.createPosixSpawnFileActions();
        try {
            int[] fds = this.createPipes();
            int rc = LibC.posix_spawn_file_actions_init(posix_spawn_file_actions);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stdinWidow, 0);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[0]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stdoutWidow, 1);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[1]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            rc = LibC.posix_spawn_file_actions_adddup2(posix_spawn_file_actions, this.stderrWidow, 2);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = LibC.posix_spawn_file_actions_addclose(posix_spawn_file_actions, fds[2]);
            OsxProcess.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_addclose() failed");
            return posix_spawn_file_actions;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception creating posix pipe actions", e);
            LibC.posix_spawn_file_actions_destroy(posix_spawn_file_actions);
            throw e;
        }
    }

    private Pointer createPosixSpawnFileActions() {
        return new Memory((long)Native.POINTER_SIZE);
    }

    private Pointer createPosixSpawnAttributes() {
        return new Memory((long)Native.POINTER_SIZE);
    }

    static {
        for (int i = 0; i < processors.length; ++i) {
            OsxProcess.processors[i] = new ProcessKqueue();
        }
        LibC.signal(31, LibC.SIG_IGN);
    }
}

